package cn.quantgroup.xyqb.controller.modifyphoneno.req;

import cn.quantgroup.user.enums.ModifyPhoneNoApplyStatusEnum;
import cn.quantgroup.user.enums.ModifyPhoneNoProcessingStatusEnum;
import cn.quantgroup.xyqb.controller.req.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * Date: 2019/11/5
 * Time: 下午4:02
 *
 * @author: yangrui
 */
@Data
public class ModifyPhoneNoQueryReq extends Page {

    /**
     * 申请人旧手机号
     */
    @ApiModelProperty("申请人旧手机号")
    private String phoneNo;

    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private String startAt;

    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private String endAt;

    /**
     * 申请状态 0处理中; 1修改完成; 2不允许修改;
     */
    @ApiModelProperty("申请状态 INIT 处理中; DONE 修改完成; NO_ALLOW 不允许修改;")
    private ModifyPhoneNoApplyStatusEnum applyStatus;

    /**
     * 处理状态 0待人工处理 1待用户反馈结果 2已反馈
     */
    @ApiModelProperty("处理状态 INIT 待人工处理; WAIT_4_USER_FEEDBACK 待用户反馈结果; DONE 已反馈;")
    private ModifyPhoneNoProcessingStatusEnum processingStatus;
}
