package cn.quantgroup.xyqb.controller.middleoffice.common.image;

import cn.quantgroup.xyqb.service.captcha.IQuantgroupCaptchaService;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

/**
 * 量化派验证码认证
 */
@Component
public class QgVerifyStrategy implements IImageVerifyStrategy {

    @Resource
    private IQuantgroupCaptchaService quantgroupCaptchaService;

    @Override
    public ImageVerifyTypeEnum strategyName() {
        return ImageVerifyTypeEnum.qg;
    }

    @Override
    public boolean verify(ImageDTO image) {
        return quantgroupCaptchaService.validQuantgroupCaptcha(image.getCaptchaId(), image.getCaptchaValue());
    }
}
