package service;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = Bootstrap.class)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class GeetestCaptchaServiceTest {

    @Resource
    private IGeetestCaptchaService geetestCaptchaService;

    @Test
    public void testFetchGeetestCaptcha(){
        Assert.assertNotNull(geetestCaptchaService.fetchGeetestCaptcha(PasswordUtil.MD5("18010043006"),"127.0.0.1", ClientType.APP));
    }


    @Test
    public void testValidGeetestCaptcha(){
        String challenge = "d6e965e06b187c0a01276834d2ff00e6";
        String validate = "validate";
        String seccode = "seccode";
        Assert.assertTrue(geetestCaptchaService.validGeetestCaptcha(ClientType.APP,"127.0.0.1", PasswordUtil.MD5("18010043006"),challenge,validate,seccode));
    }
}
