package cn.quantgroup.xyqb.service.captcha.qg;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.thirdparty.jcaptcha.AbstractManageableImageCaptchaService;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author xufei on 2018/1/30.
 */
@Service
public class QuantgroupCaptchaServiceImpl implements IQuantgroupCaptchaService{
    private static final String IMAGE_FORMAT_PNG = "png";
    private static final String IMG_BASE64_PATTREN = "data:image/" + IMAGE_FORMAT_PNG + ";base64,%s";

    /**
     * 自动化测试忽略验证码
     */
    @Value("${xyqb.auth.captcha.autotest.enable:false}")
    private boolean autoTestCaptchaEnabled;

    @Autowired
    @Qualifier("customCaptchaService")
    private AbstractManageableImageCaptchaService imageCaptchaService;

    @Override
    public Map<String, String> fetchCaptcha(HttpServletRequest request) throws Exception{
        String imageId = UUID.randomUUID().toString();
        BufferedImage challenge = imageCaptchaService.getImageChallengeForID(Constants.IMAGE_CAPTCHA_KEY + imageId, request.getLocale());
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        ImageIO.write(challenge, IMAGE_FORMAT_PNG, jpegOutputStream);

        String imageBase64 = Base64.encodeBase64String(jpegOutputStream.toByteArray());

        Map<String, String> data = new HashMap<>();
        data.put("imageId", imageId);
        data.put("image", String.format(IMG_BASE64_PATTREN, imageBase64));
        return data;
    }
}
