package cn.quantgroup.xyqb.service.captcha.geetest;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.service.captcha.geetest.sdk.GeetestLib;
import cn.quantgroup.xyqb.util.IPUtil;
import cn.quantgroup.xyqb.util.PasswordUtil;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

/**
 * @author xufei on 2018/1/30.
 */
@Service
public class GeetestCaptchaServiceImpl implements IGeetestCaptchaService {

    @Resource
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    @Override
    public GeetestLib getGeetestSdk() {
        return new GeetestLib(Constants.GEETEST_ID, Constants.GEETEST_KEY, Constants.NEW_FAIL_BACK);
    }

    @Override
    public int getGeetestServerStatus(String phoneNo, HttpServletRequest request, GeetestLib gtSdk) {
        HashMap<String, String> param = getParam(phoneNo, request);

        int gtServerStatus = gtSdk.preProcess(param);
        stringRedisTemplate.opsForValue().set(Constants.GT_SERVER_STATUS_SESSION_KEY + phoneNo,
                Integer.toString(gtServerStatus), Constants.GT_SERVER_STATUS_EXIST_REDIS, TimeUnit.MINUTES);

        //进行验证预处理
        return gtServerStatus;
    }

    private HashMap<String, String> getParam(String phoneNo, HttpServletRequest request) {
        HashMap<String, String> param = new HashMap<>();
        param.put("user_id", PasswordUtil.MD5(phoneNo));
        param.put("client_type", "H5");
        param.put("ip_address", IPUtil.getRemoteIP(request));
        return param;
    }

    @Override
    public String startCaptcha(GeetestLib gtSdk) {
        return gtSdk.getResponseStr();
    }

    @Override
    public int verifyLogin(String phoneNo, HttpServletRequest request) {
        HashMap<String, String> param = getParam(phoneNo, request);

        String challenge = request.getParameter(GeetestLib.fn_geetest_challenge);
        String validate = request.getParameter(GeetestLib.fn_geetest_validate);
        String seccode = request.getParameter(GeetestLib.fn_geetest_seccode);
        return getGeetestSdk().enhencedValidateRequest(challenge, validate, seccode, param);
    }
}
