package cn.quantgroup.xyqb.service.register.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.Contact;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.event.RegisterEvent;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.register.AbstractUserRegisterService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

/**
 * @author liqing
 * @date 2017/12/4 0004
 */
@Service("userRegisterService")
@Slf4j
public class UserRegisterServiceImpl extends AbstractUserRegisterService {

    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    private IUserService userService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User registerDefault(UserRegisterParam userRegisterParam) {
        return getDefaultUserRegisterHandler().handleRegister(userRegisterParam);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User registerExt(UserRegisterParam userRegisterParam) {
        return getExtUserRegisterHandler().handleRegister(userRegisterParam);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User register(Long registerFrom, String phoneNo, String idNo, String name, Long channelId, Long btRegisterChannelId) {
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo).idNo(idNo).name(name)
                .channelId(channelId).btRegisterChannelId(btRegisterChannelId)
                .generateRandomPwd(true).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        User user = saveUser(userRegisterParam);
        applicationEventPublisher.publishEvent(new RegisterEvent(this, userRegisterParam));
        return user;
    }

    private User saveUser(UserRegisterParam userRegisterParam) {
        String uuid = UUID.randomUUID().toString();
        User user = new User();
        user.setUuid(uuid);
        user.setEnable(true);
        user.setPhoneNo(userRegisterParam.getPhoneNo());
        Long registerFrom = userRegisterParam.getRegisterFrom();
        if (Objects.isNull(registerFrom)) {
            registerFrom = 1L;
        }
        Long channelId = userRegisterParam.getChannelId();
        if (Objects.equals(channelId, 222L)) {
            user.setRegisteredFrom(channelId);
        } else {
            user.setRegisteredFrom(registerFrom);
        }
        String password = StringUtils.defaultString(userRegisterParam.getPassword(), "");
        // 如果需要生成随机密码
        if (userRegisterParam.isGenerateRandomPwd()) {
            password = PasswordUtil.generateRandomPwd(Constants.RANDOM_PWD_LEN);
        }
        user.setPassword(PasswordUtil.MD5(password.toLowerCase() + Constants.PASSWORD_SALT));
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        user.setUpdatedAt(currentTime);
        user.setCreatedAt(currentTime);
        user = userService.saveUser(user);
        userRegisterParam.setUser(user);
        return user;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean register(String phoneNo, String password, Long registerFrom, String ip, Long channelId, Long btRegisterChannelId, String dimension) {
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo).password(password)
                .channelId(channelId).btRegisterChannelId(btRegisterChannelId)
                .dimension(dimension)
                .generateRandomPwd(false).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        User user = saveUser(userRegisterParam);
        applicationEventPublisher.publishEvent(new RegisterEvent(this, userRegisterParam));
        return user != null;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User register(String phoneNo, Long channelId, Long registerFrom, String appChannel, Long btRegisterChannelId, String dimension) {
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registerFrom).phoneNo(phoneNo)
                .channelId(channelId).btRegisterChannelId(btRegisterChannelId)
                .dimension(dimension)
                .generateRandomPwd(true).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        User user = saveUser(userRegisterParam);
        applicationEventPublisher.publishEvent(new RegisterEvent(this, userRegisterParam));
        return user;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public User register(Long registeredFrom, Long channelId, String phoneNo, String name, String idNo, Address addressObj, String contacts, List<Contact> contactList, Long btRegisterChannelId) {
        UserRegisterParam userRegisterParam = UserRegisterParam.builder()
                .registerFrom(registeredFrom).phoneNo(phoneNo).idNo(idNo).name(name)
                .channelId(channelId)
                .btRegisterChannelId(btRegisterChannelId)
                .address(addressObj).contacts(contacts)
                .contactList(contactList)
                .generateRandomPwd(true).sendSuccessSms(true).sendAppSms(true)
                .sendSuccessMq(true)
                .build();
        User user = saveUser(userRegisterParam);
        applicationEventPublisher.publishEvent(new RegisterEvent(this, userRegisterParam));
        return user;
    }

}
