package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserDeregisterRecord;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 销户 Repository
 *
 * @author killer
 * @date 2021年12月29日12:05:01
 */
public interface IUserDeregisterRecordRepository extends JpaRepository<UserDeregisterRecord, Long> {

    /**
     * 通过用户手机号md5查询销户记录
     *
     * @param phoneNo 手机号md5
     * @return List<UserDeregisterRecord>
     */
    List<UserDeregisterRecord> findByPhoneNo(String phoneNo);

    /**
     * 删除注销时间大于90天数据
     */
    @Transactional
    void deleteByDeregisterTimeIsBefore(Date dt);
}
