package cn.quantgroup.xyqb;


/**
 * Created by Miraculous on 15/7/5.
 */
public interface Constants {

    // zero fill with 4 chars...
    String ZERO_FILL_TEMPLATE = "%04d";
    String IMAGE_CAPTCHA_KEY = "img_captcha:";
    /**
     * 图形验证码缓存key
     */
    String IMAGE_CAPTCHA_REDIS_CACHE_KEY = "redis_cache_img_captcha:";
    String REDIS_CAPTCHA_KEY = "auth:";
    String REDIS_PREFIX_VERIFICATION_CODE = "verificationCode_";
    //新版短信验证码计数
    String REDIS_SMS_IP_COUNT = "SMS_Ip_verification_code_count:";
    String REDIS_SMS_CODE_COUNT = "SMS_Phone_verification_code_count:";
    String REDIS_SMS_DEVICE_COUNT = "SMS_Device_verification_code_count:";
    //新版语音验证码计数
    String REDIS_VOICE_IP_COUNT = "Voice_Ip_verification_code_count:";
    String REDIS_VOICE_CODE_COUNT = "Voice_Phone_verification_code_count:";
    String REDIS_VOICE_DEVICE_COUNT = "Voice_Device_verification_code_count:";

    String REDIS_VERIFICATION_COUNT = "verification_code_count:";
    Long Image_Need_Count = 3L;
    Long VERIFICATION_CODE_FINITE_COUNT = 3L;
    /**
     * 第几次验证需要重新获取验证码
     */
    Long VERIFICATION_CODE_FINITE_COUNT_NEW = 2L;

    String X_AUTH_TOKEN = "x-auth-token";
    String X_AUTH_TENANT = "qg-tenant-id";
    int VERIFICATION_LEN = 2;
    int SMS_CODE_LEN_4 = 4;
    int SMS_CODE_LEN_6 = 6;
    int TOKEN_LENGTH = 36;
    int MD5_LENGTH = 32;
    int THOUSAND_SECOND = 1000;
    int MILLIS_PER_SECOND = 1000;
    int MILLIS_OF_TEN_SECOND = 10000;
    int PAGE_SIZE_MAX = 200;
    int PAGE_SIZE_DEFAULT = 30;
    int DAY_NO_MAX = 31;
    int DAY_NO_MIN = 1;
    int MONTH_NO_MAX = 12;
    int MONTH_NO_MIN = 1;
    int AGE_MAX = 150;
    int USER_QUERY_INFO_BATCH_SIZE = 3000;
    int USER_ID_BATCH_SIZE = 500;
    /** 垃圾，前辈竟然用这个办法来识别UUID */
    int UUID_MIN_LENGTH = 10;
    String AUTO_SORT_TYPE = "auto";
    String CHECK_FAIL = "fail";
    String SPLIT_CHAR = ":";
    String TOKEN_MASTER = "*";
    String PASSWORD_HEADER = "Basic ";
    int AUTHORIZE_HEADER_SIZE = 2;
    String PAGE_NEXT_KEY_XYQB = "xyqb";
    /**
     * 登录账号/手机号参数名
     */
    String PHONE_NO = "phoneNo";
    String ID_NO = "idNo";
    String USER_ID = "userId";
    String USER_NAME = "name";
    String BANK_CARD = "bankCard";
    String ADDRESS = "address";
    String PASSWORD = "password";

    String RESULT_CODE = "code";
    String RESULT_DATA = "data";
    String SUCCESS_CODE = "0000";
    String PROTOCOL_HEAD_HTTPS = "https:";
    String PROTOCOL_HEAD_HTTP = "http:";
    String REDIRECT = "redirect";
    String CUSTOMREDIRECT = "customredirect";
    String LOCAL = "local";
    String REDIRECT_ORDER = "orders";
    String DOCKER_DOMAIN = "liangkebang";

    /**
     * 微信标识参数名
     */
    String WECHAT_OPEN_ID = "wechat_open_id";
    String MERCHANT_BAITIAO = "baitiao";
    String MERCHANT_WECHAT_PAY = "wechat-pay";

    // -- Start -- IPV4安全策略常量组
    /**
     * 账密不匹配错误 - 按账号计数
     */
    String REDIS_PASSWORD_ERROR_COUNT = "password_error_count:";
    /**
     * 账密不匹配错误 - 按IP计数
     */
    String REDIS_PASSWORD_ERROR_COUNT_FOR_IPV4 = "password_error_count_4_ipv4:";
    /**
     * 账密匹配成功 - 按IP计数
     */
    String REDIS_PASSWORD_SUCCESS_COUNT_FOR_IPV4 = "password_success_count_4_ipv4:";
    /**
     * 账密安全策略 - 白名单
     */
    String IPV4_LOCK_WHITE = "lock_ipv4:white:";
    /**
     * 账密安全策略 - 黑名单
     */
    String IPV4_LOCK_BLACK = "lock_ipv4:black:";
    /**
     * 账密安全策略 - 锁机制自定义参数 - 锁定分钟数
     */
    String IPV4_LOCK_MINUTES_REDIS = "lock_ipv4:minutes:";
    /**
     * 账密安全策略 - 锁机制自定义参数 - 锁开关阈值
     */
    String IPV4_LOCK_ON_COUNTS_REDIS = "lock_ipv4:on_counts:";
    /**
     * 账密安全策略 - 锁机制 - IPV4锁
     */
    String IPV4_LOCK = "lock_ipv4:";
    /**
     * 账密不匹配错误 - 锁机制默认参数 - 锁定分钟数
     */
    Long IPV4_FAILED_LOCK_MINUTES = 3 * 60L;
    /**
     * 账密不匹配错误 - 锁机制默认参数 - 计数周期
     */
    Long IPV4_FAILED_COUNT_MINUTES = 1L;
    /**
     * 账密不匹配错误 - 锁机制默认参数 - 锁开关阈值
     */
    Long IPV4_LOCK_ON_FAILED_COUNTS = 60L;
    /**
     * 账密匹配成功 - 锁机制默认参数 - 锁定分钟数
     */
    Long IPV4_SUCCESS_LOCK_MINUTES = 30L;
    /**
     * 账密匹配成功 - 锁机制默认参数 - 计数周期
     */
    Long IPV4_SUCCESS_COUNT_MINUTES = 60L;
    /**
     * 账密匹配成功 - 锁机制默认参数 - 锁开关阈值
     */
    Long IPV4_LOCK_ON_SUCCESS_COUNTS = 40L;
    /**
     * 安全策略参数设置 - 秘钥 - 口令
     */
    String CLEAR_LOCK_FOR_IPV4 = "x-clear-lock-11241842-y";
    /**
     * 安全策略参数设置 - 私钥
     */
    String CLEAR_LOCK_FOR_IPV4_KEY = "lhp.family.dwy.sjs.yym.cxy.cpg";
    // -- End -- IPV4安全策略常量组
    /**
     * redis中token的key值前缀
     */
    String SESSION_PREFIX = "spring:session:sessions:";
    /**
     * 账号密码锁定阈值
     */
    Long PASSWORD_ERROR_LOCK_COUNT = 5L;
    /**
     * 账号密码错误锁定时间 30分钟
     */
    Long PASSWORD_ERROR_LOCK_TIME = 30L;
    /**
     * 密码错误次数过多锁定key前缀
     */
    String PASSWORD_LOCK_PRE = "password_error_lock:";
    /**
     * 图形验证码有效期
     */
    Long IMAGE_CAPTCHA_REDIS_CACHE_TIME_OUT = 10L;
    /**
     * 默认随机密码长度
     */
    int RANDOM_PWD_LEN = 15;
    /** 旧的大陆身份证号长度 */
    int ID_NO_OLD_LENGTH = 15;
    /** 标准大陆身份证号长度 */
    int ID_NO_STANDARD_LENGTH = 18;
    int ID_NO_CHECK_LENGTH = 17;
    int ID_NO_AREA_CODE_LENGTH = 2;
    int ID_NO_CHECK_MASK = 11;
    int GENDER_MASK = 2;

    interface Channel {
        long BAITIAO = 222L;
        long WECHAT = 198L;
        long HENGCHANG = 58L;
    }

    interface Session {
        String USER_SESSION_CACHE = "user:session:";
        String USER_SESSION_ID_CACHE = "userid-sessionvalue:cache:";
        String USER_SESSION_KEY_SET = "userid-keys:set:";
        Long SESSION_VALID_TIME = 15 * 24 * 60 * 60L;
    }

    interface UserAvatar {
        String AVATAR_DEFAULT = "https://avatar.xyqb.com/default_avatar.png";
    }

    String AES_KEY = "ScnmRBhuQpo9kBdn";

    // -- Start -- 验证码常量组
    int GT_CAPTCHA_VALIDATE_SUCCESS = 1;
    String GT_UNIQUE_KEY = "uniqueKey";
    String FN_GEETEST_CHALLENGE = "geetest_challenge";
    String FN_GEETEST_VALIDATE = "geetest_validate";
    String FN_GEETEST_SECCODE = "geetest_seccode";
    String QG_CAPTCHA_ID = "captchaId";
    String QG_CAPTCHA_VALUE = "captchaValue";
    /**
     * 客户端类型参数名
     */
    String CLIENT_TYPE = "clientType";
    /**
     * 验证类型请求参数名
     */
    String VERIFY_PARAM = "verifyType";
    /**
     * 验证类型 - 极验
     */
    String VERIFY_TYPE_GT = "gt";
    /**
     * 验证类型 - 量化派图形验证
     */
    String VERIFY_TYPE_QG = "qg";
    // -- End -- 验证码常量组

    /** 注销用户后再次允许注册时间间隔-天数 */
    long DELETE_USER_AGAIN_REGISTER_INTERVAL = 90;
}
