
    try {
      String schema = getProtocol();
      String domain = userUiDomain;
      if(Objects.equals(schema, "https:")){
        domain = userUiDomainS;
      }
      try {
        extData = new String(Base64.decodeBase64(extData), "UTF-8");
      } catch (Exception ex) {
        extData = "";
      }
      LOGGER.info("从微信extdata版本接口进入：{}, extData:{}", schema, extData);
      if (StringUtils.isEmpty(extData)) {
        // 从code获取token
        Merchant merchant = merchantService.findMerchantByName(systemKey);
        AccessTokenResponse token = wechatService.getToken(code);
        if (token == null) {
          // 让用户登录，不关联微信, 构造不关联微信的url
          redirectNormalUrl(response, merchant, Constants.Channel.WECHAT,domain);
          return;
        }
        WechatUserInfo userInfo =
            wechatService.getWechatUserInfoFromWechatServer(token.getAccessToken(),
                token.getOpenId());
        if (userInfo == null || StringUtils.isEmpty(userInfo.getOpenId())) {
          // 让用户登录，不关联微信, 构造不关联微信的url
          redirectNormalUrl(response, merchant, Constants.Channel.WECHAT,domain);
          return;
        }
        WechatUserInfo userInfoInDb = wechatService.findWechatUserInfoFromDb(userInfo.getOpenId());
        // welcome 首次登录
        if (userInfoInDb == null) {
          // 微信用户首次登录界面, 首先保存userInfo, 跳入到微信注册登录界面
          if (StringUtils.isNotBlank(userInfo.getNickName())) {
            String nickName = EmojiUtil.filter(userInfo.getNickName());
            userInfo.setNickName(nickName);
          }
          userInfo = wechatService.saveWechatUserInfo(userInfo);
          redirectWechatLoginUrlWithoutLogin(response, merchant, userInfo,
              Constants.Channel.WECHAT,domain);
          return;
        }
        if (userInfoInDb.getUserId() == null) {
          // 用户已经微信登录了，但是没有关联信用钱包，跳转到注册页面
          redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb,
              Constants.Channel.WECHAT,domain);
          return;
        }
        User user = userService.findById(userInfoInDb.getUserId());
        if (user == null) {
          redirectWechatLoginUrlWithoutLogin(response, merchant, userInfoInDb,
              Constants.Channel.WECHAT,domain);
          return;
        }
        // 已经关联了用户
        // create session, 登进去，该怎么玩怎么玩。
        String redirectUrl =
            createUserSession(user, merchant, "", schema, Constants.Channel.WECHAT);
        response.setHeader("Location", redirectUrl);
        response.setStatus(301);
      } else {
        HashMap<String, Object> extDataObj;
        try {
          extDataObj = JSON.parseObject(extData, new TypeReference<HashMap<String, Object>>(){});
        } catch (Exception ex) {
          LOGGER.error("解析extData发生错误", ex);
        }
        schema = extDataObj.getOrDefault("protocol", "http:").toString();
        domain = userUiDomain;
        if(Objects.equals(schema, "https:")){
          domain = userUiDomainS;
        }
        LOGGER.info("从微信登录extData中获得协议信息,protocol:{}", schema);
        Long registerFrom = Long.valueOf(extDataObj.getOrDefault("registerFrom", "1").toString());
        String redirect = (String) extDataObj.getOrDefault("redirect", "redirect");
        LOGGER.info("从微信登录,registerFrom:{}, redirect:{}", registerFrom, redirect);
      }
    } catch (Exception ex) {
      LOGGER.error("发生异常", ex);
      throw ex;
    }