package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.config.http.Timestamp2LongConverter;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by Administrator on 2017/5/16.
 */
@Getter
@Setter
@ToString
@Entity
@Table(name = "user_bt_register")
public class UserBtRegister implements Serializable {
    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "register_bt_merchant_id")
    private Long registerBtMerchantId;

    @Column(name = "is_active")
    private Boolean isActive = Boolean.TRUE;

    //创建时间
    @Column(name = "created_at")
    private Timestamp createdAt;

    //上一次修改时间
    @Column(name = "updated_at")
    @JSONField(serializeUsing = Timestamp2LongConverter.class)
    private Timestamp updatedAt;


    @PrePersist
    public void prePersist() {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.createdAt = now;
        this.updatedAt = now;
    }


    @PreUpdate
    public void preUpdate() {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.createdAt = now;
        this.updatedAt = now;
    }
}
