package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.constant.enums.RecordType;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.LoginRecord;
import cn.quantgroup.xyqb.repository.ILoginRecordRepository;
import cn.quantgroup.xyqb.service.user.ILoginRecordService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by Miraculous on 15/7/5.
 */
@Service
@Slf4j
public class LoginRecordServiceImpl implements ILoginRecordService, IBaseController {

    @Autowired
    private ILoginRecordRepository loginRecordRepository;

    @Override
    public void saveLoginRecord(Long userId, String name, int loginType) {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        LoginRecord loginRecord = new LoginRecord();
        loginRecord.setUserId(userId);
        loginRecord.setType(name);
        // 如果登陆记录登陆方式
        if (RecordType.LOGINRECORD.getName().equals(name)) {
            loginRecord.setLoginType(loginType);
        }
        String qgTenantId = request.getHeader("qg-tenant-id");
        String vccChannel = request.getHeader("vccChannel");
        String registeredFrom = request.getHeader(Constants.X_AUTH_FROM);
        if (null != qgTenantId && !"".equals(qgTenantId)) {
            loginRecord.setQgTenantId(Long.parseLong(qgTenantId));
        }
        if (null != vccChannel && !"".equals(vccChannel)) {
            loginRecord.setVccChannel(Long.parseLong(vccChannel));
        }
        if (null == vccChannel) {
            loginRecord.setVccChannel(StringUtils.isEmpty(registeredFrom) ? null : Long.parseLong(vccChannel));
        }

        loginRecord.setUserTerminal(request.getHeader("x-user-terminal"));
        loginRecord.setIp(request.getHeader("x-original-client-ip"));
        loginRecord.setAppName(request.getHeader("appName"));
        loginRecord.setVersion(request.getHeader("version"));
        loginRecord.setUserAgent(request.getHeader("User-Agent"));
        loginRecord.setDeviceId(request.getHeader("scDeviceId"));
        loginRecord.setAppChannel(request.getHeader("appChannel"));
        loginRecordRepository.saveAndFlush(loginRecord);
    }

    @Override
    public LoginRecord findFirstLoginRecord(String deviceId) {
        return loginRecordRepository.findFirstByDeviceIdOrderByCreatedAtDesc(deviceId);
    }
}
