package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserInfoEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface IUserInfoRepository extends JpaRepository<UserInfoEntity, Long> {
    UserInfoEntity findByUserIdAndTenantId(Long userId,Integer tenantId);

    UserInfoEntity findByPhoneNoAndTenantId(String phoneNo,Integer tenantId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update user_info set qq = ?1 where user_id = ?2 and tenant_id = ?3", nativeQuery = true)
    void updateUserQq(String qq, Long userId,Integer tenantId);

    List<UserInfoEntity> findByTenantIdAndPhoneNoIn(Integer tenantId, List<String> phoneNos);
    List<UserInfoEntity> findByTenantIdAndUserIdIn(Integer tenantId,List<Long> userIds);
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update user_info set email = ?1 where user_id = ?2 and tenant_id = ?3", nativeQuery = true)
    void updateUserEmail(String email, Long userId,Integer tenantId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update user_info set gender = ?1 where user_id = ?2 and tenant_id = ?3", nativeQuery = true)
    void updateGender(int gender, Long userId,Integer tenantId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update user_info set name=?1,gender=?2 where phone_no=?3 and tenant_id = ?4", nativeQuery = true)
    int updateNameAndGenderByPhoneNo(String name,int gender, String phoneNo,Integer tenantId);

}
