package service;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.util.Map;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = Bootstrap.class)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class GeetestCaptchaServiceTest {
    @Resource
    private IGeetestCaptchaService geetestCaptchaService;

    private String phoneNo = "18953309449";
    private String remoteIp = "192.168.12.24";
    private ClientType clientType = ClientType.H5;
    private Map<String, String> data = null;

    @Test
    public void testFetchGeetestCaptcha(){
        data = geetestCaptchaService.fetchGeetestCaptcha(PasswordUtil.MD5(phoneNo), remoteIp, clientType);
        Assert.assertNotNull(data);
        Assert.assertTrue(data.containsKey("gt"));
        Assert.assertTrue(data.containsKey("challenge"));
    }

    @Test
    public void testValidGeetestCaptcha(){
        String challenge = "86664ca9f3feba52c1d070343a9d10c6";
        String validate = "9b80dd76a43e2608e54da9b865733b8c";
        String seccode = "9b80dd76a43e2608e54da9b865733b8c|jordan";
        Assert.assertTrue(geetestCaptchaService.validGeetestCaptcha(PasswordUtil.MD5(phoneNo), remoteIp, clientType, challenge, validate, seccode));
    }
}
