package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.aspect.logcaller.LogHttpCaller;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.*;
import cn.quantgroup.user.enums.*;
import cn.quantgroup.xyqb.model.*;
import cn.quantgroup.xyqb.model.IdType;
import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.Contact;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.entity.UserExtInfo;
import cn.quantgroup.xyqb.entity.UserSpouse;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
//import cn.quantgroup.xyqb.entity.enumerate.EducationEnum;
//import cn.quantgroup.xyqb.entity.enumerate.IncomeEnum;
//import cn.quantgroup.xyqb.entity.enumerate.IncomeRangeEnum;
//import cn.quantgroup.xyqb.entity.enumerate.MaritalStatus;
//import cn.quantgroup.xyqb.entity.enumerate.OccupationEnum;
//import cn.quantgroup.xyqb.entity.enumerate.Relation;
import cn.quantgroup.xyqb.model.AddressRet;
import cn.quantgroup.xyqb.model.ContactRet;
import cn.quantgroup.xyqb.model.IdType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserDetailRet;
import cn.quantgroup.xyqb.model.UserExtInfoRet;
import cn.quantgroup.xyqb.model.UserRet;
import cn.quantgroup.xyqb.model.UserSpouseRet;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.user.*;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import cn.quantgroup.xyqb.util.ValidationUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.google.common.base.MoreObjects;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableMap;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

/**
 * Created by Miraculous on 2016/12/19.
 */
@RestController
@RequestMapping("/innerapi")
public class InnerController implements IBaseController {

  private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(InnerController.class);
  private final static Random random = new Random();

  @Autowired
  private IUserService userService;
  @Autowired
  private IUserDetailService userDetailService;
  @Autowired
  private IIdCardService idCardService;
  @Autowired
  private IUserExtInfoService userExtInfoService;
  @Autowired
  private IContactService contactService;
  @Autowired
  private IAddressService addressService;
  @Autowired
  private IWechatService wechatService;
  @Autowired
  private IUserSpouseService userSpouseService;
  @Autowired
  private ISessionService sessionService;

  @Autowired
  private IHttpService httpService;

  @Value("${xyqb.user.query.url}")
  private String queryUrl;

  @Value("${xyqb.auth.url}")
  private String hanguguanUrl;

  private static final ObjectMapper MAPPER = new ObjectMapper();

  static {
    MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    MAPPER.configure(SerializationFeature.WRITE_ENUMS_USING_INDEX, true);
  }

  @Autowired
  private ILkbUserService lkbUserService;

  private Long BAITIAO_CHANNEL = 222L;

  @RequestMapping("/user/search/phoneNo")
  @LogHttpCaller
  public JsonResult findByPhoneNo(String phoneNo) {
    User user = userService.findByPhoneInDb(phoneNo);
    if (user == null) {
      return JsonResult.buildErrorStateResult("", null);
    }
    UserRet userRet = UserRet.getUserRet(user);
    return JsonResult.buildSuccessResult("", userRet);
  }

  @RequestMapping("/user/search/uuid")
  @LogHttpCaller
  public JsonResult findByUuid(String uuid) {
    User user = userService.findByUuidInDb(uuid);
    if (user == null) {
      return JsonResult.buildErrorStateResult("", null);
    }
    UserRet userRet = UserRet.getUserRet(user);
    return JsonResult.buildSuccessResult("", userRet);
  }

  @RequestMapping("/user/getPhoneByUserIds")
  @LogHttpCaller
  public JsonResult findByIds(@RequestParam(value = "userIds") String userIdsString) {
    LOGGER.info("批量查询用户的手机号列表, userIdsString:" + userIdsString);
    if (StringUtils.isEmpty(userIdsString)) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    List<Long> userIds = JSONObject.parseObject(userIdsString, new TypeReference<List<Long>>() {
    });
    if(!CollectionUtils.isEmpty(userIds) && userIds.size()<=500) {
      Map<Long, String> userIdAndPhoneMap = userService.findPhoneByIdsInDb(userIds);
      return JsonResult.buildSuccessResult("", userIdAndPhoneMap);
    }else {
      return JsonResult.buildErrorStateResult("批量查询每次最多进行500条用户信息的查询",null);
    }
  }

  @RequestMapping("/user/save")
  public JsonResult saveUser(
      String phoneNo, Long registeredFrom, Long createdAt, Long updatedAt,
      String password, String uuid) {
    //参数验证
    if (StringUtils.isBlank(phoneNo)) {
      return JsonResult.buildErrorStateResult("用户手机号不能为空.", null);
    }
    if (registeredFrom == null) {
      registeredFrom = 0L;
    }
    if (StringUtils.isBlank(password)) {
      password = "";
    }
    if (StringUtils.isBlank(uuid)) {
      return JsonResult.buildErrorStateResult("用户uuid为空.", null);
    }
    if (createdAt == 0L || updatedAt == 0L) {
      createdAt = System.currentTimeMillis();
      updatedAt = System.currentTimeMillis();
    }
    User user = userService.findByPhoneWithCache(phoneNo);
    if (user == null) {
      user = new User();
    }else if(!user.getEnable()){
      return JsonResult.buildErrorStateResult("用户已经注销", null);
    }
    if (org.apache.commons.lang.StringUtils.isEmpty(user.getUuid())) {
      user.setUuid(uuid);
    }
    user.setPhoneNo(phoneNo);
    user.setCreatedAt(new Timestamp(createdAt));
    user.setUpdatedAt(new Timestamp(updatedAt));
    user.setEnable(true);
    user.setRegisteredFrom(registeredFrom);
    user.setUuid(uuid);
    user.setPassword(password);
    user = userService.saveUser(user);
    UserRet userRet = null;
    if (user != null) {
      userRet = UserRet.getUserRet(user);
    }
    return JsonResult.buildSuccessResult(null, userRet);
  }

  /**
   * 保存用户详细信息
   *
   * @param userId
   * @param phoneNo
   * @param name
   * @param idNo
   * @param email
   * @return
   */
  @RequestMapping("/user_detail/save")
  public JsonResult saveUserDetail(Long userId, String phoneNo, String name, String idNo,
                                   String email, Long id) {
    //参数验证
    if (userId == null || userId == 0L) {
      return JsonResult.buildErrorStateResult("用户id为空.", null);
    }
    if (StringUtils.isBlank(phoneNo)) {
      return JsonResult.buildErrorStateResult("用户手机号为空.", null);
    }
    if (StringUtils.isBlank(name)) {
      return JsonResult.buildErrorStateResult("用户名为空.", null);
    }
    if (StringUtils.isBlank(idNo)) {
      return JsonResult.buildErrorStateResult("用户身份证为空.", null);
    }
    UserDetail userDetail = new UserDetail();
    if (id != null && id > 0) {
      userDetail.setId(id);
    }
    userDetail.setUserId(userId);
    userDetail.setName(name);
    userDetail.setPhoneNo(phoneNo);
    userDetail.setIdNo(idNo);
    Timestamp time = new Timestamp(System.currentTimeMillis());
    userDetail.setCreatedAt(time);
    userDetail.setUpdatedAt(time);
    userDetail.setIdType(IdType.ID_CARD);
    try {
      userDetail.setGender(idCardService.getIdCardInfo(idNo).getGender());
    } catch (ParseException e) {
      LOGGER.error("根据身份证获取性别出错,错误信息:" + e);
      return JsonResult.buildErrorStateResult(null, null);
    }
    userDetail.setEmail(email);
    userDetail = userDetailService.saveUserDetail(userDetail);
    if (userDetail != null) {
      return JsonResult.buildSuccessResult(null, UserDetailRet.getUserDetail(userDetail));
    }
    return JsonResult.buildErrorStateResult("", null);
  }

  /**
   * 根据用户id查询用户的详细信息
   *
   * @param userId
   * @return
   */
  @RequestMapping("/user_detail/search/userId")
  @LogHttpCaller
  public JsonResult findUserDetailByUserId(Long userId) {
    UserDetail userDetail = userDetailService.findByUserId(userId);
    if (userDetail != null) {
      return JsonResult.buildSuccessResult(null, UserDetailRet.getUserDetail(userDetail));
    }
    return JsonResult.buildErrorStateResult("", null);
  }

  @RequestMapping("/user/search/userId")
  @LogHttpCaller
  public JsonResult findUserByUserId(Long userId) {
    User user = userService.findById(userId);
    if (user != null) {
      return JsonResult.buildSuccessResult(null, UserRet.getUserRet(user));
    }
    return JsonResult.buildErrorStateResult("", null);
  }

  @RequestMapping("/user_detail/search/phone")
  @LogHttpCaller
  public JsonResult findUserDetailByPhone(String phoneNo) {
    UserDetail userDetail = userDetailService.findByPhoneNo(phoneNo);
    if (userDetail != null) {
      return JsonResult.buildSuccessResult(null, UserDetailRet.getUserDetail(userDetail));
    }
    return JsonResult.buildErrorStateResult("", null);
  }

  @RequestMapping("/user_detail/update/qq")
  public JsonResult updateUserQQ(String qq, Long userId) {
    if (StringUtils.isEmpty(qq) || userId == null || userId == 0L) {
      return JsonResult.buildErrorStateResult("参数校验失败,qq或用户id为空", null);
    }
    userDetailService.updateUserQQ(userId, qq);
    return JsonResult.buildSuccessResult(null, null);
  }

  @RequestMapping("/contact/search/user_id")
  @LogHttpCaller
  public JsonResult findContactsByUserId(Long userId) {
    if (null == userId) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    List<Contact> contacts = contactService.findByUserId(userId);
    if (null == contacts || contacts.size() == 0) {
      return JsonResult.buildErrorStateResult(null, Collections.emptyList());
    }
    return JsonResult.buildSuccessResult(null, ContactRet.contacts2ContactRets(contacts));
  }

  @RequestMapping("/contact/save/contacts")
  public JsonResult save2Contact(Long userId, @RequestParam(value = "contacts") String contactsStr) {
    LOGGER.info("保存用户联系人:userId:{}, contacts:" + contactsStr);
    if (StringUtils.isEmpty(contactsStr)) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    if (userId == null) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    List<Contact> userContact = contactService.findByUserId(userId);
    if (userContact != null && userContact.size() >= 2) {
      return JsonResult.buildSuccessResult(null, ContactRet.contacts2ContactRets(userContact));
    }
    List<Contact> contacts = JSONObject.parseObject(contactsStr, new TypeReference<List<Contact>>() {
    });
    if (CollectionUtils.isEmpty(contacts)) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    Timestamp now = new Timestamp(System.currentTimeMillis());
    convertContactList(userId, contacts, now);
    List<Contact> result = contactService.save(contacts);
    return JsonResult.buildSuccessResult(null, ContactRet.contacts2ContactRets(result));
  }

  private void convertContactList(Long userId, List<Contact> contacts, Timestamp now) {
    for (Contact c : contacts) {
      c.setId(null);
      c.setUserId(userId);
      c.setRelation(c.getRelation() == null ? Relation.OTHER : c.getRelation());
      c.setCreatedAt(now);
      c.setUpdateAt(now);
    }
  }



  @RequestMapping("/address/search/user_id")
  public JsonResult findAddressByUserId(Long userId) {
    if (userId == null) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    Address address = addressService.findByUserId(userId);
    if (address == null) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    return JsonResult.buildSuccessResult(null, AddressRet.address2AddressRet(address));
  }

  @RequestMapping("/address/save")
  public JsonResult saveAddress(
      Long userId, Long provinceCode, Long cityCode, String city,
      Long districtCode, String district, String address, String province) {
    LOGGER.info("保存地址详情:city:{},province:{}" + city, province);
    if (userId == null || provinceCode == null || cityCode == null) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    Address addressObj = addressService.findByUserId(userId);
    if (addressObj == null) {
      addressObj = new Address();
      Timestamp now = new Timestamp(System.currentTimeMillis());
      addressObj.setCreatedAt(now);
      addressObj.setUpdateAt(now);
    }
    addressObj.setUserId(userId);
    addressObj.setProvinceCode(provinceCode);
    addressObj.setCityCode(cityCode);
    addressObj.setCity(city);
    addressObj.setDistrictCode(districtCode);
    addressObj.setDistrict(district);
    addressObj.setAddress(address);
    addressObj.setProvince(province);
    addressObj = addressService.save(addressObj);
    return JsonResult.buildSuccessResult(null, AddressRet.address2AddressRet(addressObj));
  }


  @RequestMapping("/user_ext_info/update")
  public JsonResult updateMarryStatus(
      Long userId, IncomeEnum incomeEnum, IncomeRangeEnum incomeRangeEnum,
      OccupationEnum occupationEnum, EducationEnum educationEnum, Boolean hasCar,
      Boolean hasSocialSecurity, Boolean hasHouse, Boolean hasCreditCard, MaritalStatus maritalStatus) {
    if (null == userId) {
      return JsonResult.buildErrorStateResult("用户ID不能为空", null);
    }
    UserExtInfo info = userExtInfoService.findByUserId(userId);
    Timestamp now = new Timestamp(System.currentTimeMillis());
    if (info == null) {
      info = new UserExtInfo();
      info.setUserId(userId);
      info.setCreatedAt(now);
    }
    info.setUpdateAt(now);
    if (incomeEnum != null) {
      info.setIncomeEnum(incomeEnum);
    }
    if (incomeRangeEnum != null) {
      info.setIncomeRangeEnum(incomeRangeEnum);
    }
    if (occupationEnum != null) {
      info.setOccupationEnum(occupationEnum);
    }
    if (educationEnum != null) {
      info.setEducationEnum(educationEnum);
    }
    if (hasCar != null) {
      info.setHasCar(hasCar);
    }
    if (hasSocialSecurity != null) {
      info.setHasCreditCard(hasCreditCard);
    }
    if (hasHouse != null) {
      info.setHasHouse(hasHouse);
    }
    if (maritalStatus != null) {
      info.setMarryStatus(maritalStatus);
    }
    info = userExtInfoService.save(info);
    return JsonResult.buildSuccessResult(null, UserExtInfoRet.getUserExtInfoRet(info));
  }

  @RequestMapping("/user_detail/search_list")
  @LogHttpCaller
  public JsonResult searchUserDetailList(String name, String phoneNo, String idNo) {

    LOGGER.info("searchUserDetailList ,param.name:{},phone:{},idNo:{},ip:{}",name,phoneNo,idNo,getIp());
    if (StringUtils.isBlank(name) && StringUtils.isBlank(phoneNo) && StringUtils.isBlank(idNo)) {
      return JsonResult.buildErrorStateResult("至少必须满足一个条件不为空", null);
    }

    /*List<UserDetailVO> userDetails = userDetailService.searchUserDetailList(name, phoneNo, idNo);
    return JsonResult.buildSuccessResult("success", userDetails);*/

    ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
    if(StringUtils.isNotBlank(name)){
      builder.put("name",name);
    }
    if(StringUtils.isNotBlank(phoneNo)){
      builder.put("phoneNo",phoneNo);
    }
    if(StringUtils.isNotBlank(idNo)){
      builder.put("idNo",idNo);
    }
    Map<String, String> param =builder.build();
    String s = httpService.get(queryUrl.concat("/innerapi/user_detail/search_list"), param);
    return  JSON.parseObject(s, JsonResult.class);
  }

  @RequestMapping("/user_ext_info/search/user_id")
  public JsonResult searchUserExtInfoByUserId(Long userId) {
    if (userId == null) {
      return JsonResult.buildErrorStateResult("userId不能为空", null);
    }
    UserExtInfo userExtInfo = userExtInfoService.findByUserId(userId);
    if (userExtInfo == null) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    return JsonResult.buildSuccessResult(null, UserExtInfoRet.getUserExtInfoRet(userExtInfo));
  }

  @RequestMapping("/user/query/openId")
  @LogHttpCaller
  public JsonResult queryOpenIdByUserId(Long userId) {
    if (userId == null) {
      return JsonResult.buildErrorStateResult("userId不能为空", null);
    }
    WechatUserInfo wechatUserInfo = wechatService.queryOpenIdByUserId(userId);
    if (wechatUserInfo == null) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    return JsonResult.buildSuccessResult("success", wechatUserInfo.getOpenId());
  }

  @RequestMapping("/user/wechat/phone_no")
  @LogHttpCaller
  public JsonResult queryOpenIdByPhoneNo(String phoneNo) {
    if (StringUtils.isBlank(phoneNo)) {
      return JsonResult.buildErrorStateResult("手机号错误", null);
    }
    if (!ValidationUtil.validatePhoneNo(phoneNo)) {
      return JsonResult.buildErrorStateResult("手机号格式错误", null);
    }
    WechatUserInfo wechatUserInfo = wechatService.findWechatUserInfoByPhoneNo(phoneNo);
    return JsonResult.buildSuccessResult(null, null == wechatUserInfo ? null : wechatUserInfo.getOpenId());
  }

  @RequestMapping("/user/disable")
  public JsonResult disableUser(Long userId) {
    if (null == userId || 0L == userId) {
      return JsonResult.buildErrorStateResult("userId不能为空", null);
    }
    User user = userService.findById(userId);
    if (null == user) {
      return JsonResult.buildErrorStateResult("未查询到该用户,用户id:" + userId, null);
    }
    user.setEnable(false);
    user.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
    LOGGER.info("注销用户的信息,userId={}", userId);
    user = userService.saveUser(user);
    if (!user.getEnable()) {
      sessionService.deleteByUserId(userId);
    }
    LOGGER.info("去清除函谷关的缓存");
    httpService.get(hanguguanUrl.concat("/innerapi/disableUserCache"),ImmutableMap.of("phone",user.getPhoneNo()));
    return JsonResult.buildSuccessResult("用户已禁用.", user.getEnable() == false);
  }

  @RequestMapping("/user/spouse/save")
  public JsonResult saveSpouse(Long userId, MaritalStatus status, String spousePhone, String spouseName) {
    if (userId == null || userId == 0) {
      return JsonResult.buildErrorStateResult("用户不能为空", null);
    }
    if (status == MaritalStatus.MARRIED) {
      if (!ValidationUtil.validatePhoneNo(spousePhone)) {
        return JsonResult.buildErrorStateResult("手机号格式错误", null);
      }
      if (StringUtils.isBlank(spouseName)) {
        return JsonResult.buildErrorStateResult("配偶姓名不能为空", null);
      }
    }
    UserSpouse userSpouse = userSpouseService.findByUserId(userId);
    Timestamp timestamp = new Timestamp(System.currentTimeMillis());
    if (userSpouse == null) {
      userSpouse = new UserSpouse(userId);
      userSpouse.setCreatedAt(timestamp);
    }
    userSpouse.setSpouseName(status == MaritalStatus.MARRIED ? spouseName : "");
    userSpouse.setSpousePhone(status == MaritalStatus.MARRIED ? spousePhone : "");
    userSpouse.setStatus(status);
    userSpouse.setUpdateAt(timestamp);
    userSpouse = userSpouseService.save(userSpouse);
    return JsonResult.buildSuccessResult(null, UserSpouseRet.getUserSpouseRet(userSpouse));
  }

  @RequestMapping("/user/spouse/findByUserId")
  @LogHttpCaller
  public JsonResult querySpouse(Long userId) {
    if (userId == null || userId == 0) {
      return JsonResult.buildErrorStateResult("用户不能为空", null);
    }
    UserSpouse userSpouse = userSpouseService.findByUserId(userId);
    if (userSpouse == null) {
      userSpouse = new UserSpouse(userId);
      userSpouse.setStatus(MaritalStatus.UNKNOWN);
    }
    return JsonResult.buildSuccessResult(null, UserSpouseRet.getUserSpouseRet(userSpouse));
  }


  @RequestMapping("/user/findByPhones")
  public JsonResult getUserIdByPhones(@RequestParam("userPhones")String userPhones){
    if(StringUtils.isBlank(userPhones)){
      return JsonResult.buildErrorStateResult("传入用户手机号不可为空",null);
    }
    List<String> phones = JSONObject.parseObject(userPhones, new TypeReference<List<String>>() {
    });
    if(org.apache.commons.collections.CollectionUtils.isNotEmpty(phones)) {
      if(!(phones.size()>500)) {
        List<User> users = userService.findByPhones(phones);
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(users)) {
          return JsonResult.buildSuccessResult(null, users.stream().collect(Collectors.toMap(User::getPhoneNo,User::getId)));
        }else {
          return JsonResult.buildSuccessResult(null, null);
        }
      }
      return JsonResult.buildErrorStateResult("单次批量查询不可超过500个手机号",null);
    }
    return JsonResult.buildErrorStateResult("传入用户手机号不可为空", null);
  }


  /**
   * 重置密码接口，供内部人员使用（例如绝影）
   * @param key
   * @param phone
   * @return
   */
  @RequestMapping("/user/password/reset/{key}/{phone}")
  public JsonResult resetPassword(@PathVariable("key")String key,@PathVariable("phone")String phone) {
    LOGGER.info("密码重置请求,phone:[{}]",phone);
    if(StringUtils.isBlank(key)){
      return JsonResult.buildErrorStateResult("用户密码重置失败.", null);
    }
    if(!"ecf75c1f-2ccb-4661-8e4b-2874c0f45a2b".equalsIgnoreCase(key)){
      LOGGER.error("密码重置失败,key错误!@!,phone:[{}]", phone);
      return JsonResult.buildErrorStateResult("用户密码重置失败.", null);
    }
    try {
      userService.resetPassword(phone, "123456"); //默认重置的密码是123456
      return JsonResult.buildSuccessResult("用户密码已重置.", "null");
    }catch (Exception e){
      LOGGER.error("密码重置失败,phone[{}],err:[{}]",phone, e);
    }
    return JsonResult.buildErrorStateResult("用户密码重置失败.", null);

  }


  /**
   * 保存用户信息，地址信息，联系人信息
   * @param registeredFrom
   * @param channelId
   * @param phoneNo
   * @param name
   * @param idNo
   * @param provinceCode
   * @param cityCode
   * @param districtCode
   * @param address
   * @param contacts
   * @return
   */
  @RequestMapping("/user/save_multi")
  public JsonResult saveMulti(
          String registeredFrom,
          String channelId,
          String phoneNo,
          String name,
          String idNo,
          String provinceCode,
          String province,
          String cityCode,
          String city,
          String districtCode,
          String district,
          String address,
          String contacts) {
    LOGGER.info("保存用户、联系人、地址信息:registeredFrom:[{}], phoneNo[{}]，name[{}]，idNo[{}]，provinceCode[{}]，cityCode[{}]，districtCode[{}]，" +
            "address[{}]，contacts[{}]",registeredFrom,phoneNo,name,idNo,provinceCode,cityCode,districtCode,address,contacts);

    if(!NumberUtils.isDigits(registeredFrom)){
      return JsonResult.buildErrorStateResult("注册渠道异常.", null);
    }

    if(!NumberUtils.isDigits(phoneNo)){
      return JsonResult.buildErrorStateResult("手机号异常.", null);
    }
    if(StringUtils.isBlank(name)){
      return JsonResult.buildErrorStateResult("用户名异常.", null);
    }
    if(!NumberUtils.isDigits(idNo)){
      return JsonResult.buildErrorStateResult("用户身份证号异常.", null);
    }
    if(!NumberUtils.isDigits(provinceCode)){
      return JsonResult.buildErrorStateResult("省份编号异常.", null);
    }
    if(StringUtils.isBlank(province)){
      return JsonResult.buildErrorStateResult("省份异常.", null);
    }
    if(!NumberUtils.isDigits(cityCode)){
      return JsonResult.buildErrorStateResult("城市编号异常.", null);
    }
    if(StringUtils.isBlank(city)){
      return JsonResult.buildErrorStateResult("城市异常.", null);
    }
    if(!NumberUtils.isDigits(districtCode)){
      return JsonResult.buildErrorStateResult("区县编号异常.", null);
    }
    if(StringUtils.isBlank(district)){
      return JsonResult.buildErrorStateResult("区县异常.", null);
    }
    if (StringUtils.isBlank(address)) {
      return JsonResult.buildErrorStateResult("详细地址异常.", null);
    }


    channelId = MoreObjects.firstNonNull(channelId, "-1");
    // 验证用户是否已存在
    User user = userService.findByPhoneInDb(phoneNo);
    if(null != user){
      return JsonResult.buildErrorStateResult("用户已存在，手机号被占用", null);
    }

    user = userService.registerAndReturn(Long.valueOf(registeredFrom), Long.valueOf(channelId), phoneNo, name, idNo, provinceCode, province, cityCode, city, districtCode, district, address, contacts);

    UserRet userRet = UserRet.getUserRet(user);
    return JsonResult.buildSuccessResult(null, userRet);

  }

  @RequestMapping("/user/register")
  public JsonResult register(String phoneNo, String password, Long channelId) {
    if (!ValidationUtil.validatePhoneNo(phoneNo)) {
      return JsonResult.buildErrorStateResult("手机号不正确", null);
    }
    User user = userService.findByPhoneInDb(phoneNo);
    if (user == null) {
      user = userService.registerAndReturn(phoneNo, StringUtils.defaultString(password, ""), channelId);
    }
    if (user == null) {
      return JsonResult.buildErrorStateResult("注册失败", null);
    }
    return JsonResult.buildSuccessResult(null, UserRet.getUserRet(user));
  }

}