package cn.quantgroup.xyqb.service.auth;

import cn.quantgroup.xyqb.model.JsonResult;

import java.util.Map;

/**
 * @author xufei on 2018/1/5.
 */
public interface IUserAuthorizedService {
    /**
     * 该身份证是否有对应的实名账户
     *
     * @param idNo 身份证号
     * @return
     */
    JsonResult hasUserAuthorized(String idNo);

    /**
     * 创建实名账户
     *
     * @param name        用户姓名
     * @param idNo        身份证号
     * @param userId      userId
     * @param authPattern 认证方式
     * @return
     */
    JsonResult createUserAuthorized(String name, String idNo, Long userId, String authPattern);

    /**
     * 通过userId获取实名账户表的id
     *
     * @param userId userId
     * @return
     */
    JsonResult getUserAuthorizedId(Long userId);
}
