package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.UserTag;
import cn.quantgroup.xyqb.repository.IUserTagRepository;
import cn.quantgroup.xyqb.service.captcha.IGeetestLogService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * user_tag表，用来监听
 */
@Component
public class GeeTestLoginEventListener implements ApplicationListener<UserLoginEvent> {

    @Autowired
    private IGeetestLogService geetestLogService;

    /**
     * 逻辑 每次登录发送UserLoginEvent，落user_tag表
     * 如果没有就新增，如果有就更新
     *
     * @param userLoginEvent UserLoginEvent
     */
    @Override
    public void onApplicationEvent(UserLoginEvent userLoginEvent) {
        if (StringUtils.isNotEmpty(userLoginEvent.getGeetestId()) && userLoginEvent.getUserTag()!=null) {
            geetestLogService.updateByUidGeetestLog(Long.valueOf(userLoginEvent.getGeetestId()),userLoginEvent.getUserTag().getUserId());
        }
    }
}
