package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import lombok.Getter;
import org.springframework.context.ApplicationEvent;

/**
 * @author 徐小光
 */
@Getter
public class PhoneNoUpdateEvent extends ApplicationEvent {

    private User user;
    private String oldPhoneNo;

    /**
     * Create a new ApplicationEvent.
     *
     * @param source the object on which the event initially occurred (never {@code null})
     */
    public PhoneNoUpdateEvent(Object source) {
        super(source);
    }

    public PhoneNoUpdateEvent(Object source, User user, String oldPhoneNo) {
        super(source);
        this.user = user;
        this.oldPhoneNo = oldPhoneNo;
    }
}
