package cn.quantgroup.xyqb.config.sentry;

import io.sentry.Sentry;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerExceptionResolver;

import javax.annotation.PostConstruct;

/**
 * 初始化Sentry配置
 * @author renwc
 * @date 2018-05-22
 */
@Configuration
public class SentryConfig {

    @Value("${dsn}")
    private String dsn;

    @Bean
    public HandlerExceptionResolver sentryExceptionResolver() {
        return new io.sentry.spring.SentryExceptionResolver();
    }

    @Bean
    public ServletContextInitializer sentryServletContextInitializer() {
        return new io.sentry.spring.SentryServletContextInitializer();
    }

    @PostConstruct
    public void initSentry(){
        Sentry.init(dsn);
    }
}
