package cn.quantgroup.xyqb.entity.enums;

import lombok.Getter;

@Getter
public enum Device {


    ANDROID("安卓", "android"),
    IOS("IOS", "ios");

    private String desc;
    private String code;

    Device(String desc, String code) {
        this.desc = desc;
        this.code = code;
    }

   public static Device valueOfCode(String code) {
        if(null == code){
            return null;
        }
        for (Device device : Device.values()) {
            if (device.code.equals(code)) {
                return device;
            }
        }
        return null;
    }

}
