package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.entity.enums.Device;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.sql.Timestamp;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/11/23 8:26
 * @description：用户登录信息表
 * @modified By：
 * @version: 1.0
 */
@Data
@Entity
@Table(name = "login_info")
public class LoginInfo extends BaseEntity {


    @Column(name = "phone_no")
    private String phoneNo;

    @Column(name = "device_id")
    private String deviceId;

    @Column(name = "device")
    private Device device;

    @Column(name = "last_ip")
    private String lastIp;

    @Column(name = "login_count")
    private Long loginCount;

    @Column(name = "last_login_at")
    private Timestamp lastLoginAt;


/**
 * CREATE TABLE `login_info` (
 *   `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '自增主键',
 *   `phone_no` varchar(15) NOT NULL COMMENT '手机号',
 *   `device_id` varchar(50) NOT NULL COMMENT '设备ID',
 *   `device` int(2) DEFAULT NULL COMMENT '设备类型(0安卓,1IOS)',
 *   `last_ip` varchar(30) DEFAULT NULL COMMENT '同手机设备最后一次登录的IP',
 *   `login_count` int(11) DEFAULT '1' COMMENT '同账户设备登录次数',
 *   `last_login_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最后一次登陆时间',
 *   `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间(第一次登陆时间)',
 *   `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
 *   PRIMARY KEY (`id`),
 *   UNIQUE KEY `phone_deviceid_idx` (`phone_no`,`device_id`) USING BTREE,
 *   KEY `deviceid_idx` (`device_id`) USING BTREE,
 *   KEY `create_at_idx` (`created_at`) USING BTREE,
 *   KEY `last_login_at_idx` (`last_login_at`) USING BTREE
 * ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='登录信息表';
 */
}
