package cn.quantgroup.xyqb.service.auth.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.UserAuthorized;
import cn.quantgroup.xyqb.model.AuthPattern;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.repository.IUserAuthorizedRepository;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.auth.IUserAuthorizedService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.sql.Timestamp;
import java.text.ParseException;

/**
 * @author xufei on 2018/1/5.
 */
@Service
public class UserAuthorizedServiceImpl implements IUserAuthorizedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAuthorizedServiceImpl.class);
    @Resource
    private IIdCardService iIdCardService;

    @Resource
    private IUserAuthorizedRepository userAuthorizedRepository;

    @Override
    public JsonResult hasUserAuthorized(String idNo) {
        try {
            if (StringUtils.isBlank(idNo) || !iIdCardService.isIdCardValid(idNo)) {
                return null;
            }
        } catch (ParseException e) {
            LOGGER.error("[hasUserAuthorized]参数异常e:{}", e);
        }

        UserAuthorized userAuthorized = userAuthorizedRepository.findByIdNo(idNo);
        LOGGER.info("[hasUserAuthorized]查询实名账户userAuthorized:{}", userAuthorized);
        return JsonResult.buildSuccessResult(null, null != userAuthorized);
    }

    @Override
    public JsonResult createUserAuthorized(String name, String idNo, Long userId, String authPattern) {
        try {
            if (StringUtils.isBlank(name) || StringUtils.isBlank(idNo) || StringUtils.isBlank(authPattern)
                    || !iIdCardService.isIdCardValid(idNo)) {
                return JsonResult.buildErrorStateResult(null, Constants.CREATE_USER_AUTHORIZED_FAIL);
            }
        } catch (ParseException e) {
            LOGGER.error("[createUserAuthorized]参数异常e:{}", e);
        }
        AuthPattern authPatternEnum = AuthPattern.valueOf(authPattern);

        UserAuthorized userAuthorized = new UserAuthorized();
        userAuthorized.setAuthPattern(authPatternEnum);
        userAuthorized.setAvailable(Boolean.TRUE);
        userAuthorized.setName(name);
        userAuthorized.setIdNo(idNo);
        userAuthorized.setUserId(userId);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        userAuthorized.setCreatedAt(now);
        userAuthorized.setUpdatedAt(now);
        try {
            userAuthorized = userAuthorizedRepository.save(userAuthorized);
            LOGGER.info("[createUserAuthorized]创建实名账户成功,userAuthorized:{}", userAuthorized);
            return JsonResult.buildSuccessResult(null, Constants.CREATE_USER_AUTHORIZED_SUCCESS);
        } catch (Exception e) {
            LOGGER.error("[createUserAuthorized]创建实名账户异常e:{}", e);
            return JsonResult.buildErrorStateResult(null, Constants.CREATE_USER_AUTHORIZED_FAIL);
        }
    }

    @Override
    public JsonResult getUserAuthorizedId(Long userId) {
        if (null == userId || userId == 0) {
            return JsonResult.buildErrorStateResult(null, null);
        }

        UserAuthorized userAuthorized = userAuthorizedRepository.findByUserId(userId);
        if (null == userAuthorized) {
            LOGGER.info("[getUserAuthorizedId]该实名账户不存在userId:{}", userId);
            return JsonResult.buildErrorStateResult(null, null);
        }
        LOGGER.info("[getUserAuthorizedId]获取实名账户的id,userAuthorized:{}", userAuthorized);
        return JsonResult.buildSuccessResult(null, userAuthorized.getId());
    }
}
