package cn.quantgroup.xyqb.controller.internal.user;

import cn.quantgroup.xyqb.aspect.logcaller.LogHttpCaller;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.auth.IUserAuthorizedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author xufei on 2018/1/5.
 */
@RestController
@RequestMapping("/user/auth")
public class UserAuthorizedController {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserAuthorizedController.class);

    @Resource
    private IUserAuthorizedService userAuthorizedService;

    @LogHttpCaller
    @RequestMapping(value = "/hasUserAuthorized")
    public JsonResult hasUserAuthorized(String idNo) {
        LOGGER.info("[hasUserAuthorized]需要校验的用户的身份证号为idNo:{}", idNo);
        return userAuthorizedService.hasUserAuthorized(idNo);
    }

    @LogHttpCaller
    @RequestMapping(value = "/createUserAuthorized")
    public JsonResult createUserAuthorized(String name, String idNo, Long userId, String authPattern) {
        LOGGER.info("[createUserAuthorized]创建实名账户,name:{},idNo:{},", name, idNo, userId, authPattern);
        return userAuthorizedService.createUserAuthorized(name, idNo, userId, authPattern);
    }

    @LogHttpCaller
    @RequestMapping(value = "/getUserAuthorizedId")
    public JsonResult getUserAuthorizedId(Long userId) {
        LOGGER.info("[getUserAuthorizedId]获取实名账户的id，userId:{}", userId);
        return userAuthorizedService.getUserAuthorizedId(userId);
    }
}
