package service;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.model.AuthPattern;
import cn.quantgroup.xyqb.service.auth.IUserAuthorizedService;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import demo.BaseParametersTests;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.Collection;

/**
 * 业务层测试用例
 * @author renwc
 * @date 2018-01-05
 */
@Slf4j
@Rollback
@Transactional
@RunWith(value = Parameterized.class)
@SpringBootTest(classes = Bootstrap.class)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class UserAuthorizedServiceTests extends BaseParametersTests {

    @Autowired
    private IUserAuthorizedService userAuthorizedService;

    private Long userId;
    private String idNo;
    private String name;
    private AuthPattern authPattern;
    private Boolean available;
    public UserAuthorizedServiceTests(Long userId, String idNo, String name, AuthPattern authPattern, Boolean available) {
        this.userId = userId;
        this.idNo = idNo;
        this.name = name;
        this.authPattern = authPattern;
        this.available = available;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {1L,"350504198805144101","史书一", AuthPattern.ZMXY, true},
                {10L,"350504198805144102","史书二", AuthPattern.ZMXY, true},
                {20L,"350504198805144103","史书三", AuthPattern.FOUR_ELEMENTS_OF_BANK_CARD, true},
                {1L, "IDNO-1", "王-1", AuthPattern.ZMXY, true}
        };
        return Arrays.asList(data);
    }

    @Test
    public void testExist() throws Exception {
        log.info("testExist: name:{}, idNo:{}, userId:{}, authPattern:{}", this.name, this.idNo, this.userId, this.authPattern);
        Object obj = userAuthorizedService.hasUserAuthorized(this.idNo);
        Assert.assertNotNull(obj);
    }

    @Test
    public void testSave() throws Exception {
        log.info("testSave: name:{}, idNo:{}, userId:{}, authPattern:{}", this.name, this.idNo, this.userId, this.authPattern);
        Object obj = userAuthorizedService.createUserAuthorized(this.name, this.idNo, this.userId, this.authPattern.name());
        Assert.assertNotNull(obj);
    }

    @Test
    public void testQuery(){
        log.info("testQuery: name:{}, idNo:{}, userId:{}, authPattern:{}", this.name, this.idNo, this.userId, this.authPattern);
        Object obj = userAuthorizedService.getUserAuthorizedId(this.userId);
        Assert.assertNotNull(obj);
    }

}
