package cn.quantgroup.xyqb.model;

import java.io.Serializable;
import java.util.Objects;

import lombok.Data;

import cn.quantgroup.xyqb.entity.User;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by 11 on 2016/12/20.
 */
@Data
public class UserRet implements Serializable {
    private static final long serialVersionUID = -1L;

    private Long id;

    //手机号
    private String phoneNo;

    //uuid
    private String password;

    //第一次用户来源 channel_id
    private Long registeredFrom;

    //uuid
    private String uuid;

    private Boolean enable;

    //创建时间
    private Long createdAt;

    private String encryptedPhoneNo;

    //上一次修改时间
    private Long updatedAt;

    /**
     * 是否有密码
     * @return
     */
    private boolean hasPassword;

    public UserRet(User user) {
        if(Objects.isNull(user)){
            return;
        }
        Long createTimeStamp = user.getCreatedAt().getTime();
        Long updateTimeStamp = user.getUpdatedAt().getTime();
        this.setId(user.getId());
        this.setPhoneNo(user.getPhoneNo());
        this.setEnable(user.getEnable());
        this.setPassword(null);
        this.hasPassword = Objects.nonNull(user.getPassword()) && !Objects.equals("", user.getPassword());
        this.setRegisteredFrom(user.getRegisteredFrom());
        this.setUuid(user.getUuid());
        this.setEncryptedPhoneNo(user.getEncryptedPhoneNo());
        this.setCreatedAt(createTimeStamp);
        this.setUpdatedAt(updateTimeStamp);
    }
}
