package cn.quantgroup.xyqb.util;

import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.Iterator;
import java.util.Map;

public class XxlJobSpringExecutor extends XxlJobExecutor implements ApplicationContextAware {

  private static ApplicationContext applicationContext;

  public void start() throws Exception {
    this.initJobHandlerRepository(applicationContext);
    super.start();
  }

  private void initJobHandlerRepository(ApplicationContext applicationContext) {
    if (applicationContext != null) {
      Map<String, Object> serviceBeanMap = applicationContext
          .getBeansWithAnnotation(JobHandler.class);
      if (serviceBeanMap != null && serviceBeanMap.size() > 0) {
        Iterator var3 = serviceBeanMap.values().iterator();

        while (var3.hasNext()) {
          Object serviceBean = var3.next();
          if (serviceBean instanceof IJobHandler) {
            String name = ((JobHandler) serviceBean.getClass().getAnnotation(JobHandler.class))
                .value();
            IJobHandler handler = (IJobHandler) serviceBean;
            if (loadJobHandler(name) != null) {
              throw new RuntimeException("xxl-job jobhandler naming conflicts.");
            }

            registJobHandler(name, handler);
          }
        }
      }

    }
  }

  public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    XxlJobSpringExecutor.applicationContext = applicationContext;
  }

  public static ApplicationContext getApplicationContext() {
    return applicationContext;
  }
}

