package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import lombok.Data;
import org.springframework.util.Assert;

import java.io.Serializable;

/**
 * Created by xuran on 2017/7/5.
 */
@Data
public class UserInfo implements Serializable {
    private static final long serialVersionUID = -1L;

    private Long id;

    private String name;

    private String phoneNo;

    private Long registerFrom;

    private String uuid;
    private String IdNo;

    public UserInfo(User user, UserDetail userDetail) {
        Assert.notNull(user, "User信息无效");
        this.id = user.getId();
        this.phoneNo = user.getPhoneNo();
        this.registerFrom = user.getRegisteredFrom();
        this.uuid = user.getUuid();
        if (userDetail != null) {
            this.name = userDetail.getName();
        }
    }
}
