package cn.quantgroup.xyqb.service.captcha.geetest;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.service.captcha.geetest.sdk.GeetestLib;
import cn.quantgroup.xyqb.util.PasswordUtil;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

/**
 * @author xufei on 2018/1/30.
 */
@Service
public class GeetestCaptchaServiceImpl implements IGeetestCaptchaService {

    @Resource
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    @Value("${gt.server.status.exist.time}")
    private long gtServerStatusExistTime;

    @Value("${geetest.captcha.id}")
    private String captchaId;

    @Value("${geetest.private.key}")
    private String privateKey;

    @Value("${geetest.new.fail.back}")
    private boolean newFailback;

    @Value("${geetest.api.url}")
    private String apiUrl;

    @Override
    public GeetestLib getGeetestSdk() {
        return new GeetestLib(captchaId, privateKey, newFailback,apiUrl);
    }

    @Override
    public int getGeetestServerStatus(String phoneNo, String remoteIp, GeetestLib gtSdk) {
        HashMap<String, String> param = getParam(phoneNo, remoteIp);
        int gtServerStatus = gtSdk.preProcess(param);

        stringRedisTemplate.opsForValue().set(Constants.GT_SERVER_STATUS_SESSION_KEY + phoneNo,
                Integer.toString(gtServerStatus), gtServerStatusExistTime, TimeUnit.MINUTES);

        //进行验证预处理
        return gtServerStatus;
    }

    private HashMap<String, String> getParam(String phoneNo, String remoteIp) {
        HashMap<String, String> param = new HashMap<>();
        param.put("user_id", PasswordUtil.MD5(phoneNo));
        param.put("client_type", "H5");
        param.put("ip_address", remoteIp);
        return param;
    }


    @Override
    public String startCaptcha(GeetestLib gtSdk) {
        return gtSdk.getResponseStr();
    }

    @Override
    public int verifyLogin(String phoneNo, String remoteIp, String challenge, String validate, String seccode) {
        HashMap<String, String> param = getParam(phoneNo, remoteIp);
        return getGeetestSdk().enhencedValidateRequest(challenge, validate, seccode, param);
    }
}
