package cn.quantgroup.xyqb;

import cn.quantgroup.tech.shutdown.DefaultSignalHandler;
import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import io.sentry.Sentry;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import sun.misc.Signal;

@ComponentScan(basePackages = {"cn.quantgroup.sms", "cn.quantgroup.xyqb"})
@SpringBootApplication
@EnableCaching
@EnableAspectJAutoProxy
@EnableAsync
@Slf4j
public class Bootstrap {

    public static void main(String[] args) {
        SpringApplication springApplication = new SpringApplication(Bootstrap.class);
        springApplication.addListeners(new ApplicationListener<ContextRefreshedEvent>() {
            @Override
            public void onApplicationEvent(ContextRefreshedEvent event) {
                MotanSwitcherUtil.setSwitcherValue(MotanConstants.REGISTRY_HEARTBEAT_SWITCHER, true);
                log.info("注册zookeeper成功");
            }
        });
        springApplication.setRegisterShutdownHook(true);
        ConfigurableApplicationContext run = springApplication.run(args);
        log.info("server start...");
        // 启用平滑退出功能
        Signal.handle(new Signal("INT"), new DefaultSignalHandler(run));
        // 异常log捕获
        Environment environment = run.getBean(Environment.class);
        String dsn = environment.getProperty("dsn");
        Sentry.init(dsn);
    }

}
