package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.UserInfoEntity;
import cn.quantgroup.xyqb.util.DateUtils;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneOffset;

/**
 * Created by 11 on 2016/12/20.
 */
@Data
public class UserInfoRet implements Serializable {
    private static final long serialVersionUID = -1L;
    private Long id;

    private Long userId;

    private String phoneNo;

    private String nickName;




    //0 未知 1 女 2 男
    private Gender gender;

    private String email;

    private String qq;
    private String address;
    private Integer provinceId;
    private Integer cityId;
    private LocalDate birthday;
    private String photo;

    private Integer tenantId;
    //创建时间
    private Long createdAt;

    //上一次修改时间
    private Long updatedAt;

    /**
     * 转换时间从timestamp到long
     * @param userInfoEntity UserInfoEntity
     * @return UserInfoRet
     */
    public static UserInfoRet getUserDetail(UserInfoEntity userInfoEntity) {
        Long createTimeStamp = DateUtils.getTimestamp(userInfoEntity.getCreatedAt());
        Long updateTimeStamp = DateUtils.getTimestamp(userInfoEntity.getUpdatedAt());

        UserInfoRet userDetailRet = new UserInfoRet();
        userDetailRet.setId(userInfoEntity.getId());
        userDetailRet.setUserId(userInfoEntity.getUserId());
        userDetailRet.setPhoneNo(userInfoEntity.getPhoneNo());
        userDetailRet.setNickName(userInfoEntity.getNickName());
        userDetailRet.setGender(userInfoEntity.getGender());
        userDetailRet.setEmail(StringUtils.defaultIfEmpty(userInfoEntity.getEmail(), ""));
        userDetailRet.setQq(StringUtils.defaultIfEmpty(userInfoEntity.getQq(), ""));
        userDetailRet.setAddress(userInfoEntity.getAddress());
        userDetailRet.setProvinceId(userInfoEntity.getProvinceId());
        userDetailRet.setCityId(userDetailRet.getCityId());
        userDetailRet.setBirthday(userDetailRet.getBirthday());
        userDetailRet.setPhoto(userDetailRet.getPhoto());
        userDetailRet.setTenantId(userInfoEntity.getTenantId());
        userDetailRet.setCreatedAt(createTimeStamp);
        userDetailRet.setUpdatedAt(updateTimeStamp);
        return userDetailRet;
    }

}
