package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

@Slf4j
@Component
public class BlackHoleRegisteredEventListener implements ApplicationListener<RegisterEvent> {

    @Value("${registered.notify.black.hole.rabbitmq.connection.exchange}")
    private String exchange;
    @Value("${registered.notify.black.hole.rabbitmq.connection.routingKey}")
    private String routingKey;
    @Resource
    private RabbitTemplate registeredNotifyBlackHoleRabbitTemplate;

    @Override
    public void onApplicationEvent(RegisterEvent event) {
        UserRegisterParam userRegisterParam = event.getUserRegisterParam();
        User user = userRegisterParam.getUser();
        log.info("onApplicationEvent cn.quantgroup.xyqb.event.BlackHoleRegisteredEventListener start user = 【{}】", user);
        LocalDate signDate = LocalDate.now();
        String dateStr = signDate.format(DateTimeFormatter.ofPattern("yyyy年MM月dd日"));
        int day = signDate.getDayOfMonth();
        long templateId = 8;
        JSONObject fields = new JSONObject();
        fields.put("phoneNo", user.getPhoneNo());
        fields.put("genarateDateStr", dateStr);
        fields.put("day", day);
        JSONObject json = new JSONObject();
        json.put("userId", user.getId());
        json.put("templateId", templateId);
        json.put("fields", fields);
        JSONArray array = new JSONArray();
        array.add(json);
        registeredNotifyBlackHoleRabbitTemplate.convertAndSend(exchange, routingKey, array.toString());
    }
}
