package cn.quantgroup.xyqb.util;

import cn.quantgroup.tool.monitor.metric.MetricUtil;
import cn.quantgroup.tool.monitor.metric.http.HttpMetricInterceptor;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.*;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Slf4j
public class HttpClientUtil {

    private static PoolingHttpClientConnectionManager connectionManager = null;
    private static HttpRequestRetryHandler retryHandler = null;
    private static ConnectionKeepAliveStrategy keepAliveStrategy = null;
    private static final int TIME_OUT = 5 * 1000;  // 超时时间
    private static final int REQUEST_CONNECTION_TIME_OUT = 1 * 1000;  // 超时时间
    private static final int CONNECTION_TIME_OUT = 2 * 1000;  // 超时时间
    private static final int SOCKET_TIME_OUT = 5 * 1000;  // 超时时间
    private static ConnectionConfig connectionConfig = null;
    private static SocketConfig socketConfig = null;
    private static RequestConfig requestConfig = null;




    /**
     * 获取HttpClient
     *
     * @return
     */
    public static CloseableHttpClient getHttpClient() {

        return HttpClients.custom()
                .setConnectionManager(connectionManager)
                .setRetryHandler(retryHandler)
                .setKeepAliveStrategy(keepAliveStrategy)
                .setDefaultSocketConfig(socketConfig)
                .setDefaultConnectionConfig(connectionConfig)
                .setDefaultRequestConfig(requestConfig)
                .addInterceptorLast(HttpMetricInterceptor.pre)
                .addInterceptorFirst(HttpMetricInterceptor.post)
                .build();
    }

    /**
     * @param url
     * @param params
     * @return
     */
    public static String doGet(String url, Map<String, Object> params) {
        return doGet(url, params, null);
    }

    /**
     * @param url
     * @param headers
     * @return
     */
    public static String doGetWithHeader(String url, Map<String, String> headers) {
        return doGet(url, null, headers);
    }


    /**
     * @param url
     * @param params
     * @return
     */
    public static String doGet(String url, Map<String, Object> params, Map<String, String> headers, int ConnectTimeout, int socketTimeOut, int resultTimeOut) {
        if (StringUtils.isEmpty(url)) {
            log.info("uri cannot be empty, uri:{}", url);
            return null;
        }
        RequestBuilder requestBuilder = RequestBuilder.get();
        String method = requestBuilder.getMethod();
        log.info("{}, uri:{}, headers:{}, parameters:{}", method, url, JSON.toJSONString(params));
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            /************** 设置URI **************/
            requestBuilder.setUri(url);
            /************** 公共配置 **************/

            RequestConfig config = RequestConfig.custom()
                    .setConnectTimeout(ConnectTimeout)
                    .setSocketTimeout(socketTimeOut)
                    .setConnectionRequestTimeout(resultTimeOut)
                    .build();
            requestBuilder.setConfig(config);

            /************** 设置Header **************/
            setHeader(requestBuilder, headers);
            /************** 设置Parameter **************/
            setParameter(requestBuilder, params, method);
            /************** 发送请求 **************/
            httpResponse = getHttpClient().execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            if (statusCode == 200) {
                httpEntity = httpResponse.getEntity();
                response = EntityUtils.toString(httpEntity, "UTF-8");
            }
//            logger.info("{}, uri:{}, response:{}", method, url, response);
            return response;
        } catch (Exception e) {
            log.error("{}, uri:{}, headers:{}, parameters:{}", method, url, JSON.toJSONString(params), e);
            return null;
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            try{
                if(httpResponse!=null){
                    httpResponse.close();
                }
            }catch (Exception e){
                log.error("{}, uri:{}, headers:{}, parameters:{},关闭流出现异常", method, url, JSON.toJSONString(params), e);
            }
        }
    }

    /**
     * @param url
     * @param params
     * @return
     */
    public static String doGet(String url, Map<String, Object> params, Map<String, String> headers) {
        if (StringUtils.isEmpty(url)) {
            log.info("uri cannot be empty, uri:{}", url);
            return null;
        }
        RequestBuilder requestBuilder = RequestBuilder.get();
        String method = requestBuilder.getMethod();
        log.info("{}, uri:{}, headers:{}, parameters:{}", method, url, JSON.toJSONString(params));
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            /************** 设置URI **************/
            requestBuilder.setUri(url);
            /************** 公共配置 **************/
            setConfig(requestBuilder);
            /************** 设置Header **************/
            setHeader(requestBuilder, headers);
            /************** 设置Parameter **************/
            setParameter(requestBuilder, params, method);
            /************** 发送请求 **************/
            httpResponse = getHttpClient().execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            if (statusCode == 200) {
                httpEntity = httpResponse.getEntity();
                response = EntityUtils.toString(httpEntity, "UTF-8");
            }
//            logger.info("{}, uri:{}, response:{}", method, url, response);
            return response;
        } catch (Exception e) {
            log.error("{}, uri:{}, headers:{}, parameters:{}", method, url, JSON.toJSONString(params), e);
            return null;
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            try{
                if(httpResponse!=null){
                    httpResponse.close();
                }
            }catch (Exception e){
                log.error("{}, uri:{}, headers:{}, parameters:{},关闭流出现异常", method, url, JSON.toJSONString(params), e);
            }
        }
    }

    /**
     * @param url
     * @param params
     * @return
     */
    public static String doPost(String url, Map<String, Object> params) {
        if (StringUtils.isEmpty(url)) {
            log.info("uri cannot be empty, uri:{}", url);
            return null;
        }
        RequestBuilder requestBuilder = RequestBuilder.post();
        String method = requestBuilder.getMethod();
        log.info("{}, uri:{}, headers:{}, parameters:{}", method, url, JSON.toJSONString(params));
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            /************** 设置URI **************/
            requestBuilder.setUri(url);
            /************** 公共配置 **************/
            setConfig(requestBuilder);
            /************** 设置Header **************/
            setHeader(requestBuilder, null);

            /************** 设置Parameter **************/
            setParameter(requestBuilder, params, method);
            /************** 发送请求 **************/
            httpResponse = getHttpClient().execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            if (statusCode == 200) {
                httpEntity = httpResponse.getEntity();
                response = EntityUtils.toString(httpEntity, "UTF-8");
            }
            log.info("{}, uri:{}, response:{}", method, url, response);
            return response;
        } catch (Exception e) {
            log.error("{}, uri:{}, headers:{}, parameters:{}", method, url, JSON.toJSONString(params), e);
            return null;
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            try{
                if(httpResponse!=null){
                    httpResponse.close();
                }
            }catch (Exception e){
                log.error("{}, uri:{}, headers:{}, parameters:{},关闭流出现异常", method, url, JSON.toJSONString(params), e);
            }
        }
    }



    public static String doPostHear(String url, Map<String, Object> params, Map<String, String> headMap) {
        if (StringUtils.isEmpty(url)) {
            log.info("uri cannot be empty, uri:{}", url);
            return null;
        }

        RequestBuilder requestBuilder = RequestBuilder.post();
        String method = requestBuilder.getMethod();
        log.info("{}, uri:{}, headers:{}, parameters:{}", method, url, headMap, JSON.toJSONString(params));
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            /************** 设置URI **************/
            requestBuilder.setUri(url);
            /************** 公共配置 **************/
            setConfig(requestBuilder);
            /************** 设置Header **************/
            setHeader(requestBuilder, headMap);

            /************** 设置Parameter **************/
            setParameterJson(requestBuilder, params);
            /************** 发送请求 **************/
            CloseableHttpClient httpClient = getHttpClient();
            httpResponse = getHttpClient().execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            if (statusCode == 200) {
                httpEntity = httpResponse.getEntity();
                response = EntityUtils.toString(httpEntity, "UTF-8");
            }
            log.info("{}, uri:{}, response:{}", method, url, response);
            return response;
        } catch (Exception e) {
            log.error("{}, uri:{}, headers:{}, parameters:{}", method, url, JSON.toJSONString(params), e);
            return null;
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            try{
                if(httpResponse!=null){
                    httpResponse.close();
                }
            }catch (Exception e){
                log.error("{}, uri:{}, headers:{}, parameters:{},关闭流出现异常", method, url, JSON.toJSONString(params), e);
            }
        }
    }


    public static String doPostHearTextPlain(String url, String message, Map<String, String> headMap) {
        if (StringUtils.isEmpty(url)) {
            log.info("uri cannot be empty, uri:{}", url);
            return null;
        }

        RequestBuilder requestBuilder = RequestBuilder.post();
        String method = requestBuilder.getMethod();
        log.info("{}, uri:{}, headers:{}, entity:{}", method, url, headMap, message);
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            /************** 设置URI **************/
            requestBuilder.setUri(url);
            /************** 公共配置 **************/
            setConfig(requestBuilder);
            /************** 设置Header **************/
            setHeader(requestBuilder, headMap);

            /************** 设置Parameter **************/
            setParameterTextPlain(requestBuilder, message);
            /************** 发送请求 **************/
            CloseableHttpClient httpClient = getHttpClient();
            httpResponse = getHttpClient().execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String response = null;
            if (statusCode == 200) {
                httpEntity = httpResponse.getEntity();
                response = EntityUtils.toString(httpEntity, "UTF-8");
            }else{
                log.info("{}, uri:{}, 请求状态非200，status:{}", method, url, statusCode);
            }
            log.info("{}, uri:{}, response:{}", method, url, response);
            return response;
        } catch (Exception e) {
            log.error("{}, uri:{}, headers:{}, message:{}", method, url, message, e);
            return null;
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            try{
                if(httpResponse!=null){
                    httpResponse.close();
                }
            }catch (Exception e){
                log.error("{}, uri:{}, headers:{}, ,关闭流出现异常", method, url,  e);
            }
        }
    }
    /**
     * @param url
     * @return
     */
    public static byte[] download(String url) {
        if (StringUtils.isEmpty(url)) {
            log.info("uri cannot be empty, uri:{}", url);
            return null;
        }
        RequestBuilder requestBuilder = RequestBuilder.get();
        String method = requestBuilder.getMethod();
        log.info("{}, uri:{}, headers:{}", method, url);
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        try {
            /************** 设置URI **************/
            requestBuilder.setUri(url);
            /************** 公共配置 **************/
            setConfig(requestBuilder);
            /************** 设置Header **************/
            setHeader(requestBuilder, null);
            /************** 设置Parameter **************/
            setParameter(requestBuilder, null, method);
            /************** 发送请求 **************/
            httpResponse = getHttpClient().execute(requestBuilder.build());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            byte[] bytes = null;
            if (statusCode == 200) {
                httpEntity = httpResponse.getEntity();
                bytes = EntityUtils.toByteArray(httpEntity);
            }
            return bytes;
        } catch (Exception e) {
            log.error("{}, uri:{}, headers:{} ", method, url, e);
            return null;
        } finally {
            EntityUtils.consumeQuietly(httpEntity);
            try{
                if(httpResponse!=null){
                    httpResponse.close();
                }
            }catch (Exception e){
                log.error("{}, uri:{}, headers:{},关闭流出现异常", method, url, e);
            }
        }
    }





    /**
     * Set Parameter
     *
     * @param requestBuilder
     * @param parameters     Map<String, Object>
     * @param method
     */
    private static void setParameter(RequestBuilder requestBuilder, Map<String, Object> parameters, String method) {
        if (MapUtils.isNotEmpty(parameters)) {
            parameters = Maps.filterValues(parameters, Predicates.notNull());

            Set<Map.Entry<String, Object>> entrys = parameters.entrySet();
            /************** Get 请求 **************/
            if (method.equalsIgnoreCase(HttpGet.METHOD_NAME)) {
                for (Map.Entry<String, Object> entry : entrys) {
                    requestBuilder.addParameter(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
            }
            /************** Post 请求 **************/
            else {
                List<NameValuePair> valuePairs = new ArrayList<>();
                for (Map.Entry<String, Object> entry : entrys) {
                    valuePairs.add(new BasicNameValuePair(String.valueOf(entry.getKey()), String.valueOf(entry.getValue())));
                }
                try {
                    requestBuilder.setEntity(new UrlEncodedFormEntity(valuePairs, "UTF-8"));
                } catch (UnsupportedEncodingException e) {
                    log.error("setParameter出现异常1", e);
                }
            }
        }
    }

    private static void setParameterJson(RequestBuilder requestBuilder, Map<String, Object> parameters) {
        if (MapUtils.isNotEmpty(parameters)) {
            try {
                requestBuilder.setEntity(new StringEntity(JSONObject.toJSONString(parameters), ContentType.APPLICATION_JSON));
            } catch (UnsupportedCharsetException e) {
                log.error("setParameterJson出现异常2", e);
            }
        }
    }

    private static void setParameterTextPlain(RequestBuilder requestBuilder, String message) {
        if (StringUtils.isNotEmpty(message)) {
            requestBuilder.setEntity(new StringEntity(message, "UTF-8"));
        }
    }

    /**
     * Set Header
     *
     * @param requestBuilder
     * @param headers
     */
    private static void setHeader(RequestBuilder requestBuilder, Map<String, String> headers) {
//        requestBuilder.setHeader("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36")
//                .setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8")
//                .setHeader("Accept-Language", "zh-CN,zh;q=0.8,en;q=0.6")
//                .setHeader("Connection", "keep-alive")
//                .setHeader("XAuth-Key", "88888888");
        if (MapUtils.isNotEmpty(headers)) {
            headers = Maps.filterValues(headers, Predicates.notNull());
            Set<Map.Entry<String, String>> entrys = headers.entrySet();
            for (Map.Entry<String, String> entry : entrys) {
                requestBuilder.setHeader(entry.getKey(), entry.getValue());
//                requestBuilder.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    /**
     * @param requestBuilder
     */
    private static void setConfig(RequestBuilder requestBuilder) {
        RequestConfig config = RequestConfig.custom()
                .setConnectTimeout(TIME_OUT)
                .setSocketTimeout(TIME_OUT)
                .setConnectionRequestTimeout(TIME_OUT)
                .build();
        requestBuilder.setConfig(config);
    }

    public static void main(String[] args) {
        long l = System.currentTimeMillis();
        byte[] download = download("https://kdspstatic.q-gp.com/Fmxk0999RFmLUcmvte2aqyudzvTv");

        System.out.println(System.currentTimeMillis()-l);
    }
}
