package cn.quantgroup.xyqb.config.mq;

import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by xuran on 2017/9/7.
 */
@Configuration
public class IRegisterMqConfig {
  @Value("${register.rabbitmq.queue}")
  private String queueName;
  @Value("${register.rabbitmq.exchange}")
  private String loanVestExchange;

  @Value("${register.rabbitmq.connection.host}")
  private String host;
  @Value("${register.rabbitmq.connection.port}")
  private Integer port;
  @Value("${register.rabbitmq.connection.user}")
  private String user;
  @Value("${register.rabbitmq.connection.password}")
  private String password;
  @Value("${register.rabbitmq.connection.virtual-host}")
  private String virtualHost;
  //@Value("${loanvest.rabbitmq.stateMsgQueue}")
  //private String stateQueueName;


  @Bean(name = "registerMqFactory")
  public ConnectionFactory vestFactory() {
    CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
    connectionFactory.setChannelCacheSize(1024);
    connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
    connectionFactory.setChannelCacheSize(180 * 1000);
    connectionFactory.setConnectionCacheSize(1024);
    connectionFactory.setUsername(user);
    connectionFactory.setPassword(password);
    connectionFactory.setVirtualHost(virtualHost);
    connectionFactory.setPublisherReturns(false);
    connectionFactory.setPublisherConfirms(false);
    return connectionFactory;
  }

  @Bean(name= "registerMqAmqpAdmin")
  public AmqpAdmin loanVestAdmin(@Qualifier("registerMqFactory") ConnectionFactory vestFactory) {
    return new RabbitAdmin(vestFactory);
  }

  @Bean(name = "registerMqExchange")
  public FanoutExchange loanVestExchange() {
    return new FanoutExchange(loanVestExchange);
  }

  @Bean(name = "registerMqQueue")
  public Queue loanVestQueue() {
    return new Queue(queueName);
  }

  @Bean(name = "registerMqBinding")
  public Binding bindingLoanVest(@Qualifier("registerMqAmqpAdmin")AmqpAdmin loanVestAdmin, @Qualifier("registerMqQueue")Queue loanVestQueue, @Qualifier("registerMqExchange")FanoutExchange loanVestExchange) {
    Binding binding = BindingBuilder.bind(loanVestQueue).to(loanVestExchange);
    loanVestAdmin.declareBinding(binding);
    return binding;
  }

  @Bean(name = "registerRabbitTemplate")
  public RabbitTemplate loanVestTemplate(@Qualifier("registerMqFactory") ConnectionFactory vestFactory) {
    RabbitTemplate template = new RabbitTemplate(vestFactory);
    template.setExchange(loanVestExchange);
    return template;
  }
}
