package cn.quantgroup.xyqb.controller.internal.user;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.IdCardInfo;
import cn.quantgroup.xyqb.model.IdType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.util.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Objects;

/**
 * Created by Miraculous on 2017/1/3.
 */
@RestController
@RequestMapping("/user_detail")
public class UserDetailController implements IBaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailController.class);
  @Autowired
  private IUserDetailService userDetailService;
  @Autowired
  private IIdCardService idCardService;
  private static final Long MAX_COUNTER = 1L;
  @Autowired
  @Qualifier("stringRedisTemplate")
  private RedisTemplate<String, String> stringRedisTemplate;

  @RequestMapping("/save")
  public JsonResult saveUserdetail(String idNo, String name) {
    try {
      if (!ValidationUtil.validateChinese(name)) {
        return JsonResult.buildErrorStateResult("姓名错误", null);
      }
      IdCardInfo info = idCardService.getIdCardInfo(idNo);
      if (!info.isValid()) {
        return JsonResult.buildErrorStateResult("身份证号码错误", null);
      }
      User user = getCurrentUserFromRedis();
      if (user == null) {
        return JsonResult.buildErrorStateResult("系统错误", null);
      }
      Timestamp now = new Timestamp(System.currentTimeMillis());
      /*
       * 如果已存在记录，则更新
       */
      UserDetail userDetail = userDetailService.findByUserId(user.getId());
      if(Objects.isNull(userDetail)){
        userDetail = userDetailService.findByPhoneNo(user.getPhoneNo());
        // 按手机号查出记录，如果userId非空，说明是存疑数据或是其他用户的信息，停止修改操作，返回失败
        if(Objects.nonNull(userDetail) && Objects.nonNull(userDetail.getUserId())){
          return JsonResult.buildErrorStateResult("手机号已使用.", null);
        }
      }
      if(Objects.isNull(userDetail)){
        userDetail = new UserDetail();
        userDetail.setCreatedAt(now);
      }
      userDetail.setIdNo(idNo);
      userDetail.setPhoneNo(user.getPhoneNo());
      userDetail.setUserId(user.getId());
      userDetail.setUpdatedAt(now);
      userDetail.setName(name);
      userDetail.setGender(info.getGender());
      userDetail.setEmail("");
      userDetail.setIdType(IdType.ID_CARD);
      userDetail.setIsAuthenticated(false);
      userDetail.setQq("");
      try {
        userDetailService.saveUserDetail(userDetail);
      } catch (DataIntegrityViolationException ex) {
        return JsonResult.buildSuccessResult("", null);
      }
      return JsonResult.buildSuccessResult("", null);
    } catch (ParseException ex) {
      LOGGER.error("身份证号错误, idNo: {}", idNo);
      return JsonResult.buildErrorStateResult("身份证号码错误", null);
    }
  }

}
