package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.repository.IUserDetailRepository;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.*;
import java.util.List;

/**
 * Created by 11 on 2016/12/29.
 */
@Service
public class UserDetailServiceImpl implements IUserDetailService {

    @Autowired
    private IUserDetailRepository userDetailRepository;

    @Override
    public UserDetail findByUserId(Long userId) {
        return userDetailRepository.findByUserId(userId);
    }

    @Override
    public UserDetail saveUserDetail(UserDetail userDetail) throws DataIntegrityViolationException {
        return userDetailRepository.save(userDetail);
    }

    @Override
    public UserDetail findByPhoneNo(String phoneNo) {
        return userDetailRepository.findByPhoneNo(phoneNo);
    }

    @Override
    public void updateUserQQ(Long userId, String qq) {
        userDetailRepository.updateUserQQ(qq, userId);
    }

    @Override
    public List<UserDetail> searchUserDetailList(String name, String phoneNo, String idNo) {
        return userDetailRepository.findAll(getSpecification(name, phoneNo, idNo));
    }

    private Specification<UserDetail> getSpecification(String name, String phoneNo, String idNo) {
        Specification<UserDetail> specification = new Specification<UserDetail>() {
            @Override
            public Predicate toPredicate(Root<UserDetail> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                if (!StringUtils.isEmpty(name)) {
                    Path<String> namePath = root.get("name");
                    criteriaQuery.where(criteriaBuilder.equal(namePath, name));
                }
                if (!StringUtils.isEmpty(phoneNo)) {
                    Path<String> phonePath = root.get("phoneNo");
                    criteriaQuery.where(criteriaBuilder.equal(phonePath, phoneNo));
                }
                if (!StringUtils.isEmpty(idNo)) {
                    Path<String> idNoPath = root.get("idNo");
                    criteriaQuery.where(criteriaBuilder.equal(idNoPath, idNo));
                }
                return null;
            }
        };
        return specification;
    }
}
