package cn.quantgroup.xyqb.service.sms.impl;

import cn.quantgroup.sms.SendAndForgetMsg;
import cn.quantgroup.sms.SmsSender;
import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Collections;

/**
 * @author mengfan.feng
 * @time 2015-07-25 18:47
 */
@Service
public class SmsServiceImpl implements ISmsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(SmsServiceImpl.class);

    private static final int SMS_VERIFICATION_MAXLEN = 6;
    private static final String SMS_VERIFY_PREFIX = "sms:verify:";

    @Value("${sms.is.debug}")
    private boolean isDebug;

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    private static final SmsSender smsSender = new SmsSender();

    @Override
    public SmsSender getSmsSender() {
        if (null == smsSender) {
            return smsSender;
        }
        return this.smsSender;
    }

    @Override
    public void sendAfterRegister(String phoneNo) {
        try {
            smsSender.sendAndForget(new SendAndForgetMsg(Collections.emptyList(), "24", "1", phoneNo));
            LOGGER.info("注册完成，发送短信, phoneNo:{}", phoneNo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 检查验证码是否正确
     *
     * @param phoneNo
     * @param smsVerificationCode
     * @return
     */
    @Override
    public boolean validRegisterOrResetPasswdVerificationCode(String phoneNo, String smsVerificationCode) {
        if (StringUtils.isEmpty(smsVerificationCode) || smsVerificationCode.length() != SMS_VERIFICATION_MAXLEN) {
            return false;
        }
        String key = Constants.REDIS_PREFIX_VERIFICATION_CODE + phoneNo;
        String randomCode = stringRedisTemplate.opsForValue().get(key);
        if(StringUtils.isEmpty(randomCode)){
            return false;
        }
        String[] arr = randomCode.split(":");
        String unqiueId = arr[0];
        String code = arr[1];
        return confirmSms(smsVerificationCode, unqiueId, code);
    }

    @Override
    public boolean validateFastLoginVerificationCode(String phoneNo, String verificationCode){
        String key = Constants.REDIS_PREFIX_VERIFICATION_CODE + phoneNo;
        String randomCode = stringRedisTemplate.opsForValue().get(key);
        if(StringUtils.isBlank(randomCode)){
            return false;
        }
        String[] arr = randomCode.split(":");
        if(arr.length != 2){
            return false;
        }
        String uniqueId = arr[0];
        String code = arr[1];
        return confirmSms(verificationCode, uniqueId, code);
    }


    private boolean confirmSms(String smsVerificationCode, String unqiueId, String code) {
        if (StringUtils.equals(code, smsVerificationCode)) {
            try {
                smsSender.confirmSmsResult("1", unqiueId);
            } catch (Exception e) {
                LOGGER.info("短信验证像短信中心确认失效");
            }
            return true;
        }
        return false;
    }

}
