package cn.quantgroup.xyqb.service.auth.impl;

import cn.quantgroup.xyqb.exception.ResponseException;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.auth.IAuthApiService;
import cn.quantgroup.xyqb.service.http.IHttpService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Map;


/**
 * han-gu-guan
 *
 * @author mengfan.feng
 * @time 2015-11-13 16:43
 */
@Service
public class AuthApiServiceImpl implements IAuthApiService {

    @Autowired
    private IHttpService httpService;

    @Value("${xyqb.auth.url}")
    private String xyqbAuthUrl;

    @Override
    public String login(String phone, Long loginFrom, String key) {
        return this.getToken(phone, loginFrom, 1L, loginFrom, key);
    }

    @Override
    public String login(String phone, Long loginFrom, Long channelId, String key) {
        return this.getToken(phone, loginFrom, channelId, loginFrom, key);
    }

    @Override
    public String login(String phone, Long loginFrom, Long channelId, Long createdFrom, String key) {
        return this.getToken(phone, loginFrom, channelId, createdFrom, key);
    }

    /**
     * 用户免密登录/注册
     *
     * @param phone
     * @return
     */
    private String getToken(String phone, Long loginFrom, Long channelId, Long createdFrom, String key) {
        Map<String, String> parameters = ImmutableMap.<String, String>builder()
                .put("phoneNo", phone)
                .put("registerFrom", loginFrom + "")
                .put("channelId", channelId + "")
                .put("createdFrom", createdFrom + "")
                .put("key", key)
                .build();

        String response = httpService.post(xyqbAuthUrl + "/app/login", parameters);

        //JsonResult result = GSON.fromJson(response, JsonResult.class);
        JsonResult result = JSONObject.parseObject(response, JsonResult.class);
        if (result == null || !"0000".equals(result.getCode()) || !"0000".equals(result.getBusinessCode())) {
            throw new ResponseException("用户免密登录返回结果错误");
        }

        String token = ((Map<String, String>) result.getData()).get("token");
        if (StringUtils.isEmpty(token)) {
            throw new ResponseException("用户免密登录失败");
        }
        return token;
    }
}
