package cn.quantgroup.xyqb.service.register.impl;

import cn.quantgroup.xyqb.entity.UserDeregisterRecord;
import cn.quantgroup.xyqb.repository.IUserDeregisterRecordRepository;
import cn.quantgroup.xyqb.service.register.IUserDeregisterService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 销户服务实现
 *
 * @author killer
 * @date 2021年12月29日
 **/
@Slf4j
@Service
@RequiredArgsConstructor
public class IUserDeregisterServiceImpl implements IUserDeregisterService {

    private final IUserDeregisterRecordRepository userDeregisterRecordRepository;

    @Override
    public List<UserDeregisterRecord> queryByPhoneNo(String phoneNo) {
        return userDeregisterRecordRepository.findByPhoneNo(phoneNo);
    }
}
