package cn.quantgroup.xyqb;

import cn.quantgroup.tech.shutdown.DefaultSignalHandler;
import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import io.sentry.Sentry;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.annotation.EnableAsync;
import sun.misc.Signal;

@SpringBootApplication
@EnableCaching
@EnableAspectJAutoProxy
@EnableAsync
@Slf4j
public class Bootstrap {

    public static void main(String[] args) {
        SpringApplication springApplication = new SpringApplication(Bootstrap.class);
        springApplication.addListeners(new ApplicationListener<ContextRefreshedEvent>() {
            @Override
            public void onApplicationEvent(ContextRefreshedEvent event) {
                MotanSwitcherUtil.setSwitcherValue(MotanConstants.REGISTRY_HEARTBEAT_SWITCHER, true);
                log.info("注册zookeeper成功");
            }
        });
        springApplication.setRegisterShutdownHook(true);
        ConfigurableApplicationContext run = springApplication.run(args);
        log.info("server start...");
        // 启用平滑退出功能
        //Signal.handle(new Signal("INT"), new DefaultSignalHandler(run));
        Sentry.init("http://13ef5642903a414c910f8d0e0a2c56ee:8b351ad1abf44de3b4c25f39105fb927@172.16.4.89:9000/6");
    }
}
