package cn.quantgroup.xyqb.service.user;

import cn.quantgroup.xyqb.entity.UserAttached;

import java.util.List;

/**
 * Created by 11 on 2017/3/22.
 */
public interface UserCenterService {
    /**
     * 查询用户附加信息
     *
     * @param userId
     * @return
     */
    UserAttached searchUserAttachedByUserId(long userId);

    /**
     * 查询用户附加信息
     * @param userIds
     * @return
     */
    List<UserAttached> searchUserAttachedListByUserId(List<Long> userIds, Integer tenantId);

    /**
     * 保存用户头像
     *
     * @param userId - 用户主键
     * @param avatar - 头像url地址
     * @param tenantId 租户ID
     * @return
     */
    UserAttached saveUserAvatar(long userId, String avatar,Integer tenantId);

    /**
     * 保存用户昵称
     *
     * @param userId - 用户主键
     * @param nick   - 昵称
     * @param tenantId - 租户ID
     * @return
     */
    UserAttached saveUserNick(long userId, String nick,Integer tenantId);

    List<UserAttached> queryUserAttachListLimit(Long id);
}
