package userService;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.controller.internal.user.UserController;
import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.Contact;
import cn.quantgroup.xyqb.service.user.IAddressService;
import cn.quantgroup.xyqb.service.user.IContactService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ApplicationContext;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * Created by xuran on 2017/12/26.
 */
@SpringBootTest(classes = Bootstrap.class )
@Slf4j
@Rollback
@Transactional
@RunWith(Parameterized.class)
public class TestUserService {
    private TestContextManager testContextManager;


    @Autowired
    private IAddressService addressService;
    @Autowired
    private IContactService contactService;

    private Address addressObj;

    public TestUserService(Address addressObj) {
        super();
        this.addressObj = addressObj;
    }
    @Before
    public void setUpContext() throws Exception {
        //this is where the magic happens, we actually do "by hand" what the spring runner would do for us,
        // read the JavaDoc for the class bellow to know exactly what it does, the method names are quite accurate though
        this.testContextManager = new TestContextManager(getClass());
        this.testContextManager.prepareTestInstance(this);
    }
    @Parameterized.Parameters
    public static Collection data() {
        Address addressObj =new Address();
        addressObj.setUserId(123456L);
        addressObj.setCity("悉尼");
        addressObj.setCityCode(1L);
        addressObj.setDistrict("悉尼");
        addressObj.setDistrictCode(1L);
        addressObj.setProvince("悉尼");
        addressObj.setProvinceCode(1L);
        addressObj.setAddress("嘻哈");
        Timestamp timestamp=Timestamp.valueOf( LocalDateTime.now());
        addressObj.setCreatedAt(timestamp);
        addressObj.setUpdateAt(timestamp);
        return Arrays.asList(new Object[][]{{addressObj}});
    }


    @Test
    public void testAddress() {

        addressService.save(addressObj);
        addressObj=addressService.findByUserId(addressObj.getUserId());
        System.out.println("测试地址"+addressObj);
        List<Long> userIds= Lists.newArrayList();
        userIds.add(123456L);
        List<Address> addresses= addressService.findByUserIds(userIds);
        System.out.println("测试地址集合"+addresses.get(0));
    }


}
