package cn.quantgroup.xyqb.exception;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
public class SilentBizException extends RuntimeException {
    private String msg;
    private String businessCode;


    public SilentBizException(BizExceptionEnum bizExceptionEnum) {
        this.msg = bizExceptionEnum.getMsg();
        this.businessCode = bizExceptionEnum.getBusinessCode();
    }

    public SilentBizException(BizExceptionEnum bizExceptionEnum, String attach) {
        this.msg = bizExceptionEnum.getMsg()+attach;
        this.businessCode = bizExceptionEnum.getBusinessCode();
    }
}
