package cn.quantgroup.xyqb.remote;

import cn.quantgroup.xyqb.model.WechatPhoneBean;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

@FeignClient(name = "wechatRemoteService", url = "https://api.weixin.qq.com")
public interface WechatRemoteService {

  @GetMapping(value = "/sns/jscode2session?grant_type=authorization_code",consumes = MediaType.APPLICATION_JSON_VALUE,produces=MediaType.APPLICATION_JSON_VALUE)
  String login(@RequestParam("appid") String appid,@RequestParam("secret") String secret,@RequestParam("js_code") String jsCode);

  @GetMapping("/cgi-bin/token?grant_type=client_credential")
  Map<String,String> getAccessToken(@RequestParam("appid") String appid,@RequestParam("secret") String secret);

  @PostMapping("/wxa/business/getuserphonenumber")
  WechatPhoneBean getUserPhoneNumber(@RequestParam("access_token") String accessToken, @RequestBody Map<String,String> code);

}