package cn.quantgroup.xyqb.service.auth;

import cn.quantgroup.xyqb.entity.UserAuthorized;
import cn.quantgroup.xyqb.model.UserAuthorizedParam;

/**
 * @author xufei on 2018/1/5.
 */
public interface IUserAuthorizedService {
    /**
     * 该身份证是否有对应的实名账户
     *
     * @param idNo 身份证号
     * @return
     */
    Boolean hasUserAuthorized(String idNo);

    /**
     * 创建实名账户
     *
     * @param userAuthorizedParam
     * @return
     */
    UserAuthorized createUserAuthorized(UserAuthorizedParam userAuthorizedParam);

    /**
     * 通过userId获取实名账户表的id
     *
     * @param userUuid userUuid
     * @return
     */
    String getUserAuthorizedId(String userUuid);

    /**
     * 校验参数
     *
     * @param userAuthorizedParam
     * @return
     * @throws Exception
     */
    Boolean checkUserAuthorizedParam(UserAuthorizedParam userAuthorizedParam) throws Exception;
}
