package cn.quantgroup.xyqb.aspect.accessable;

import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.util.IPUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * IP白名单检验
 *
 * @author renwc
 * @date 2017-12-01
 */
@Aspect
@Component
public class IpValidateAdvisor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpValidateAdvisor.class);

    @Pointcut("execution(public * cn.quantgroup.xyqb.controller.internal.user.InnerController.*(..)) || @annotation(cn.quantgroup.xyqb.aspect.accessable.IpValidator)")
    private void whiteIpMatch() {
    }

    @Around("whiteIpMatch()")
    private Object doWhiteIpMatch(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        // 客户端IP
        String clientIp = IPUtil.getRemoteIP(request);
        // 白名单
        if (IPUtil.whiteOf(clientIp)) {
            return pjp.proceed();
        }
        IPUtil.logIp(LOGGER, request);
        LOGGER.error("Lock_ipv4: don't match white ip access:{}", clientIp);
        return JsonResult.buildErrorStateResult("非法访问", null);
    }
}
