package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserAuthorized;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

/**
 * @author xufei on 2018/1/5.
 */
public interface IUserAuthorizedRepository extends JpaRepository<UserAuthorized, Long>, JpaSpecificationExecutor<UserAuthorized> {
    /**
     * 通过身份证号查找实名账户
     *
     * @param idNo 身份证号
     * @return 实体
     */
    UserAuthorized findByIdNo(String idNo);

    /**
     * 通过userId查找实名账户
     *
     * @param userId 用户id
     * @return 实体
     */
    UserAuthorized findByUserId(Long userId);
}
