package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.UserAttached;
import cn.quantgroup.xyqb.repository.IUserAttachedRepository;
import cn.quantgroup.xyqb.service.user.UserCenterService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;

/**
 * Created by 11 on 2017/3/22.
 */
@Service
public class UserCenterServiceImpl implements UserCenterService {

    @Autowired
    private IUserAttachedRepository userAttachedRepository;

    @Override
    public UserAttached searchUserAttachedByUserId(long userId) {
        return userAttachedRepository.findByUserId(userId);
    }

    @Override
    public UserAttached saveUserAvatar(long userId, String avatar) {
        UserAttached userAttached = userAttachedRepository.findByUserId(userId);
        if(Objects.isNull(userAttached)){
            userAttached = createUserAttached(userId, avatar, null);
        }
        if(!Objects.equals(avatar, userAttached.getAvatar())){
            userAttached.setAvatar(avatar);
            userAttached.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
        }
        return userAttachedRepository.save(userAttached);
    }

    @Override
    public UserAttached saveUserNick(long userId, String nick) {
        UserAttached userAttached = userAttachedRepository.findByUserId(userId);
        if(Objects.isNull(userAttached)){
            userAttached = createUserAttached(userId, null, nick);
        }
        if(!Objects.equals(nick, userAttached.getNick())){
            userAttached.setNick(nick);
            userAttached.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
        }
        return userAttachedRepository.save(userAttached);
    }

    /**
     * 创建用户附加信息实体
     *
     * @param userId - 用户主键
     * @param avatar - 头像url地址
     * @param nick - 昵称
     * @return
     */
    private synchronized UserAttached createUserAttached(Long userId, String avatar, String nick) {
        UserAttached userAttached = userAttachedRepository.findByUserId(userId);
        // 更新实例
        userAttached = Optional.ofNullable(userAttached).orElse(new UserAttached());
        Timestamp now = new Timestamp(System.currentTimeMillis());
        userAttached.setUserId(userId);
        if(StringUtils.isBlank(userAttached.getAvatar())){
            userAttached.setAvatar(avatar);
        }
        if(StringUtils.isBlank(userAttached.getNick())){
            userAttached.setNick(nick);
        }
        if(Objects.isNull(userAttached.getCreatedAt())){
            userAttached.setCreatedAt(now);
        }
        userAttached.setUpdatedAt(now);
        return userAttachedRepository.save(userAttached);
    }
}
