package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserTag;
import cn.quantgroup.xyqb.repository.IUserTagRepository;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * user_tag表，用来监听
 */
@Component
public class UserTagLoginEventListener implements ApplicationListener<UserLoginEvent> {

    @Autowired
    private IUserTagRepository userTagRepository;

    @Autowired
    private IUserService userService;

    /**
     * 逻辑 每次登录发送UserLoginEvent，落user_tag表
     * 如果没有就新增，如果有就更新;
     * 新增一个逻辑：合同补签，登录的时候跟注册渠道不同，判断是否需要补签合同，如果需要，则补签
     *
     * @param userLoginEvent UserLoginEvent
     */
    @Override
    public void onApplicationEvent(UserLoginEvent userLoginEvent) {
        if (userLoginEvent.getUserTag() != null) {
            UserTag userTag = userLoginEvent.getUserTag();
            UserTag preTag = userTagRepository.findByUserIdAndTenantIdAndRegisteredFrom(userTag.getUserId(), userTag.getTenantId(), userTag.getRegisteredFrom());

            if (preTag == null) {
                preTag = userTag;
            }

            //创建时间，如果有了，不再更新
            if (userTag.getCreatedAt() == null) {
                preTag.setCreatedAt(LocalDateTime.now());
            }

            preTag.setUpdatedAt(userTag.getUpdatedAt() == null ? LocalDateTime.now() : userTag.getUpdatedAt());

            userTagRepository.save(preTag);
            User user = userService.findById(preTag.getUserId(),preTag.getTenantId());

            try {
                //补签合同，如果需要补签 BlackHoleRegisteredEventListener 签署注册和隐私协议
                //此处补签，对于合同中心，可能会重新签署，后续待合同中心处理并发问题或者重复签署逻辑
                Thread.sleep(3000);
                userService.channelUserSignContract(user,userTag.getRegisteredFrom(),userTag.getTenantId());
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}
