package cn.quantgroup.xyqb.entity;


import cn.quantgroup.xyqb.entity.baseEntity.PartitionEntity;
import cn.quantgroup.xyqb.util.StringUtils;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created with IntelliJ IDEA.
 *
 * @author: Li JianHua
 * @Date: 2021/9/23
 * @Time: 11:02
 * Description: No Description
 */
@Entity
@Table(name = "customer_login")
public class CustomerLoginEntity extends PartitionEntity implements Serializable {
    private static final long serialVersionUID = -6859480785575072675L;

    private final static String CLASS_NAME = CustomerLoginEntity.class.getSimpleName();

    @Id
    @Column(name = "ID", nullable = false)
//    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private long id;

    @Column(name = "INSTITUTION_ID", nullable = false, length = 4)
    private String institutionId;

    @Column(name = "PRODUCT_ID", nullable = false, length = 4)
    private String productId;

    @Column(name = "CUSTOMER_ID", nullable = false)
    private long customerId;

    @Column(name = "UUID", nullable = true)
    private Long uuid;

    public String getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(long customerId) {
        this.customerId = customerId;
    }

    public Long getUuid() {
        return uuid;
    }

    public void setUuid(Long uuid) {
        this.uuid = uuid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomerLoginEntity that = (CustomerLoginEntity) o;
        return customerId == that.customerId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(institutionId, productId, customerId, uuid);
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, institutionId, productId, customerId);
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

}
