package cn.quantgroup.xyqb.security;

import cn.quantgroup.xyqb.service.session.ISessionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2021/7/1 0001.
 */
public class AuthenticationAdapter {
    public Map<String, CustomerAuthenticationManager> managers = new HashMap<>();

    public AuthenticationAdapter() {
    }

    public void register(CustomerAuthenticationManager manager) {
        managers.put(manager.getPrincipal().getName(), manager);
    }

    public CustomerAuthenticationManager getManager(String name){
        return managers.get(name);
    }

    public Authentication authenticate(String principal, String credentials){
        CustomerAuthenticationManager authenticationManager = getManager(principal);
        if(authenticationManager==null){
            throw new IllegalArgumentException("No such authentication manager. "+principal);
        }

        Authentication authenticate = authenticationManager.authenticate(credentials);
        return authenticate;
    }
}
