package cn.quantgroup.xyqb;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * @author Anonymous
 * 本地启动 :
 * 在 vm options 加入以下参数, 分别是: 环境,集群配置, 日志, 集群名, 端口号
 * -Denv=dev -Didc=k8s -Dlogging.config=classpath:logback-dev.xml -DNAMESPACE=xxx -Dserver.port=8099
 */
@Slf4j
@ComponentScan(basePackages = {"cn.quantgroup.sms", "cn.quantgroup.xyqb"})
@EnableCaching
@EnableAsync
@EnableAspectJAutoProxy
@SpringBootApplication
public class Bootstrap {

    public static void main(String[] args) {
        SpringApplication springApplication = new SpringApplication(Bootstrap.class);
        springApplication.run(args);
    }

}
